"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

require("source-map-support/register");

require("colors");

var _asyncOra = require("@electron-forge/async-ora");

var _get = require("@electron/get");

var _makerBase = _interopRequireDefault(require("@electron-forge/maker-base"));

var _fsExtra = _interopRequireDefault(require("fs-extra"));

var _path = _interopRequireDefault(require("path"));

var _forgeConfig = _interopRequireDefault(require("../util/forge-config"));

var _hook = require("../util/hook");

var _messages = require("../util/messages");

var _parseArchs = _interopRequireDefault(require("../util/parse-archs"));

var _readPackageJson = require("../util/read-package-json");

var _resolveDir = _interopRequireDefault(require("../util/resolve-dir"));

var _outDir = _interopRequireDefault(require("../util/out-dir"));

var _electronVersion = require("../util/electron-version");

var _requireSearch = _interopRequireDefault(require("../util/require-search"));

var _package = _interopRequireDefault(require("./package"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class MakerImpl extends _makerBase.default {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "name", 'impl');

    _defineProperty(this, "defaultPlatforms", []);
  }

}

var _default =
/*#__PURE__*/
function () {
  var _ref = _asyncToGenerator(function* ({
    dir = process.cwd(),
    interactive = false,
    skipPackage = false,
    arch = (0, _get.getHostArch)(),
    platform = process.platform,
    overrideTargets,
    outDir
  }) {
    _asyncOra.asyncOra.interactive = interactive;
    let forgeConfig;
    yield (0, _asyncOra.asyncOra)('Resolving Forge Config',
    /*#__PURE__*/
    _asyncToGenerator(function* () {
      const resolvedDir = yield (0, _resolveDir.default)(dir);

      if (!resolvedDir) {
        throw new Error('Failed to locate makeable Electron application');
      }

      dir = resolvedDir;
      forgeConfig = yield (0, _forgeConfig.default)(dir);
    }));
    const actualOutDir = outDir || (0, _outDir.default)(dir, forgeConfig);
    const actualTargetPlatform = platform;
    platform = platform === 'mas' ? 'darwin' : platform;

    if (!['darwin', 'win32', 'linux', 'mas'].includes(actualTargetPlatform)) {
      throw new Error(`'${actualTargetPlatform}' is an invalid platform. Choices are 'darwin', 'mas', 'win32' or 'linux'`);
    }

    const makers = {};
    let targets = (overrideTargets || forgeConfig.makers).map(target => {
      if (typeof target === 'string') {
        return {
          name: target
        };
      }

      return target;
    });
    let targetId = 0;
    var _iteratorNormalCompletion = true;
    var _didIteratorError = false;
    var _iteratorError = undefined;

    try {
      for (var _iterator = targets[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
        const target = _step.value;
        let maker; // eslint-disable-next-line no-underscore-dangle

        if (target.__isElectronForgeMaker) {
          maker = target; // eslint-disable-next-line no-continue

          if (maker.platforms.indexOf(actualTargetPlatform) === -1) continue;
        } else {
          const resolvableTarget = target;
          const MakerClass = (0, _requireSearch.default)(dir, [resolvableTarget.name]);

          if (!MakerClass) {
            throw new Error(`Could not find module with name: ${resolvableTarget.name}. Make sure it's listed in the devDependencies of your package.json`);
          }

          maker = new MakerClass(resolvableTarget.config, resolvableTarget.platforms || undefined); // eslint-disable-next-line no-continue

          if (maker.platforms.indexOf(actualTargetPlatform) === -1) continue;
        }

        if (!maker.isSupportedOnCurrentPlatform) {
          throw new Error([`Maker for target ${maker.name} is incompatible with this version of `, 'electron-forge, please upgrade or contact the maintainer ', '(needs to implement \'isSupportedOnCurrentPlatform)\')'].join(''));
        }

        if (!(yield maker.isSupportedOnCurrentPlatform())) {
          throw new Error([`Cannot make for ${platform} and target ${maker.name}: the maker declared `, `that it cannot run on ${process.platform}`].join(''));
        }

        makers[targetId] = maker;
        targetId += 1;
      }
    } catch (err) {
      _didIteratorError = true;
      _iteratorError = err;
    } finally {
      try {
        if (!_iteratorNormalCompletion && _iterator.return != null) {
          _iterator.return();
        }
      } finally {
        if (_didIteratorError) {
          throw _iteratorError;
        }
      }
    }

    if (!skipPackage) {
      (0, _messages.info)(interactive, 'We need to package your application before we can make it'.green);
      yield (0, _package.default)({
        dir,
        interactive,
        arch,
        outDir: actualOutDir,
        platform: actualTargetPlatform
      });
    } else {
      (0, _messages.warn)(interactive, 'WARNING: Skipping the packaging step, this could result in an out of date build'.red);
    }

    targets = targets.filter((_, i) => makers[i]);
    (0, _messages.info)(interactive, `Making for the following targets: ${`${targets.map((t, i) => makers[i].name).join(', ')}`.cyan}`);
    const packageJSON = yield (0, _readPackageJson.readMutatedPackageJson)(dir, forgeConfig);
    const appName = forgeConfig.packagerConfig.name || packageJSON.productName || packageJSON.name;
    const outputs = [];
    yield (0, _hook.runHook)(forgeConfig, 'preMake');
    var _iteratorNormalCompletion2 = true;
    var _didIteratorError2 = false;
    var _iteratorError2 = undefined;

    try {
      for (var _iterator2 = (0, _parseArchs.default)(platform, arch, (yield (0, _electronVersion.getElectronVersion)(dir, packageJSON)))[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
        const targetArch = _step2.value;

        const packageDir = _path.default.resolve(actualOutDir, `${appName}-${actualTargetPlatform}-${targetArch}`);

        if (!(yield _fsExtra.default.pathExists(packageDir))) {
          throw new Error(`Couldn't find packaged app at: ${packageDir}`);
        }

        targetId = 0; // eslint-disable-next-line no-underscore-dangle, @typescript-eslint/no-unused-vars

        var _iteratorNormalCompletion3 = true;
        var _didIteratorError3 = false;
        var _iteratorError3 = undefined;

        try {
          for (var _iterator3 = targets[Symbol.iterator](), _step3; !(_iteratorNormalCompletion3 = (_step3 = _iterator3.next()).done); _iteratorNormalCompletion3 = true) {
            const _target = _step3.value;
            const maker = makers[targetId];
            targetId += 1; // eslint-disable-next-line no-loop-func

            yield (0, _asyncOra.asyncOra)(`Making for target: ${maker.name.green} - On platform: ${actualTargetPlatform.cyan} - For arch: ${targetArch.cyan}`,
            /*#__PURE__*/
            _asyncToGenerator(function* () {
              try {
                /**
                 * WARNING: DO NOT ATTEMPT TO PARALLELIZE MAKERS
                 *
                 * Currently it is assumed we have 1 maker per make call but that is
                 * not enforced.  It is technically possible to have 1 maker be called
                 * multiple times.  The "prepareConfig" method however implicitly
                 * requires a lock that is not enforced.  There are two options:
                 *
                 *   * Provide makers a getConfig() method
                 *   * Remove support for config being provided as a method
                 *   * Change the entire API of maker from a single constructor to
                 *     providing a MakerFactory
                 */
                maker.prepareConfig(targetArch);
                const artifacts = yield maker.make({
                  appName,
                  forgeConfig,
                  packageJSON,
                  targetArch,
                  dir: packageDir,
                  makeDir: _path.default.resolve(actualOutDir, 'make'),
                  targetPlatform: actualTargetPlatform
                });
                outputs.push({
                  artifacts,
                  packageJSON,
                  platform: actualTargetPlatform,
                  arch: targetArch
                });
              } catch (err) {
                if (err) {
                  // eslint-disable-next-line no-throw-literal
                  throw {
                    message: `An error occured while making for target: ${maker.name}`,
                    stack: `${err.message}\n${err.stack}`
                  };
                } else {
                  throw new Error(`An unknown error occured while making for target: ${maker.name}`);
                }
              }
            }));
          }
        } catch (err) {
          _didIteratorError3 = true;
          _iteratorError3 = err;
        } finally {
          try {
            if (!_iteratorNormalCompletion3 && _iterator3.return != null) {
              _iterator3.return();
            }
          } finally {
            if (_didIteratorError3) {
              throw _iteratorError3;
            }
          }
        }
      } // If the postMake hooks modifies the locations / names of the outputs it must return
      // the new locations so that the publish step knows where to look

    } catch (err) {
      _didIteratorError2 = true;
      _iteratorError2 = err;
    } finally {
      try {
        if (!_iteratorNormalCompletion2 && _iterator2.return != null) {
          _iterator2.return();
        }
      } finally {
        if (_didIteratorError2) {
          throw _iteratorError2;
        }
      }
    }

    return (0, _hook.runMutatingHook)(forgeConfig, 'postMake', outputs);
  });

  return function (_x) {
    return _ref.apply(this, arguments);
  };
}();

exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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