import 'colors';
import { IForgeResolvableMaker, ForgeArch, ForgePlatform, ForgeMakeResult } from '@electron-forge/shared-types';
import MakerBase from '@electron-forge/maker-base';
export interface MakeOptions {
    /**
     * The path to the app from which distrubutables are generated
     */
    dir?: string;
    /**
     * Whether to use sensible defaults or prompt the user visually
     */
    interactive?: boolean;
    /**
     * Whether to skip the pre-make packaging step
     */
    skipPackage?: boolean;
    /**
     * An array of make targets to override your forge config
     */
    overrideTargets?: (IForgeResolvableMaker | MakerBase<any>)[];
    /**
     * The target architecture
     */
    arch?: ForgeArch;
    /**
     * The target platform
     */
    platform?: ForgePlatform;
    /**
     * The path to the directory containing generated distributables
     */
    outDir?: string;
}
declare const _default: ({ dir, interactive, skipPackage, arch, platform, overrideTargets, outDir, }: MakeOptions) => Promise<ForgeMakeResult[]>;
export default _default;
