"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

require("source-map-support/register");

require("colors");

var _asyncOra = require("@electron-forge/async-ora");

var _debug = _interopRequireDefault(require("debug"));

var _yarnOrNpm = require("../util/yarn-or-npm");

var _resolveDir = _interopRequireDefault(require("../util/resolve-dir"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

const d = (0, _debug.default)('electron-forge:lint');

var _default =
/*#__PURE__*/
function () {
  var _ref = _asyncToGenerator(function* ({
    dir = process.cwd(),
    interactive = false
  }) {
    _asyncOra.asyncOra.interactive = interactive;
    let success = true;
    let result = null;
    yield (0, _asyncOra.asyncOra)('Linting Application',
    /*#__PURE__*/
    function () {
      var _ref2 = _asyncToGenerator(function* (lintSpinner) {
        const resolvedDir = yield (0, _resolveDir.default)(dir);

        if (!resolvedDir) {
          throw new Error('Failed to locate lintable Electron application');
        }

        dir = resolvedDir;
        d('executing "run lint" in dir:', dir);

        try {
          yield (0, _yarnOrNpm.yarnOrNpmSpawn)(['run', 'lint'], {
            stdio: process.platform === 'win32' ? 'inherit' : 'pipe',
            cwd: dir
          });
        } catch (err) {
          lintSpinner.fail();
          success = false;
          result = err;
        }
      });

      return function (_x2) {
        return _ref2.apply(this, arguments);
      };
    }());

    if (!success) {
      throw result;
    }
  });

  return function (_x) {
    return _ref.apply(this, arguments);
  };
}();

exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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