"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

require("source-map-support/register");

require("colors");

var _asyncOra = require("@electron-forge/async-ora");

var _installerBase = _interopRequireDefault(require("@electron-forge/installer-base"));

var _debug = _interopRequireDefault(require("debug"));

var _nodeFetch = _interopRequireDefault(require("node-fetch"));

var _fsExtra = _interopRequireDefault(require("fs-extra"));

var _os = _interopRequireDefault(require("os"));

var _path = _interopRequireDefault(require("path"));

var _util = require("util");

var _semver = _interopRequireDefault(require("semver"));

var _installerDmg = _interopRequireDefault(require("@electron-forge/installer-dmg"));

var _installerZip = _interopRequireDefault(require("@electron-forge/installer-zip"));

var _installerDeb = _interopRequireDefault(require("@electron-forge/installer-deb"));

var _installerRpm = _interopRequireDefault(require("@electron-forge/installer-rpm"));

var _installerExe = _interopRequireDefault(require("@electron-forge/installer-exe"));

var _messages = require("../util/messages");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const nugget = require('nugget');

const d = (0, _debug.default)('electron-forge:install');
const GITHUB_API = 'https://api.github.com';

class InstallerImpl extends _installerBase.default {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "name", 'impl');
  }

}

var _default =
/*#__PURE__*/
function () {
  var _ref = _asyncToGenerator(function* ({
    interactive = false,
    prerelease = false,
    repo,
    chooseAsset
  }) {
    _asyncOra.asyncOra.interactive = interactive;

    if (typeof chooseAsset !== 'function') {
      throw new Error('Expected chooseAsset to be a function in install call');
    }

    let latestRelease;
    let possibleAssets = [];
    yield (0, _asyncOra.asyncOra)('Searching for Application',
    /*#__PURE__*/
    function () {
      var _ref2 = _asyncToGenerator(function* (searchSpinner) {
        if (!repo || repo.indexOf('/') === -1) {
          throw new Error('Invalid repository name, must be in the format owner/name');
        }

        d('searching for repo:', repo);
        let releases;

        try {
          releases = yield (yield (0, _nodeFetch.default)(`${GITHUB_API}/repos/${repo}/releases`)).json();
        } catch (err) {// Ignore error
        }

        if (!releases || releases.message === 'Not Found' || !Array.isArray(releases)) {
          throw new Error(`Failed to find releases for repository "${repo}".  Please check the name and try again.`);
        }

        if (releases.length === 0) {
          throw new Error(`Repository "${repo}" has no releases`);
        }

        releases = releases.filter(release => !release.prerelease || prerelease);
        const sortedReleases = releases.sort((releaseA, releaseB) => {
          let tagA = releaseA.tag_name;
          if (tagA.substr(0, 1) === 'v') tagA = tagA.substr(1);
          let tagB = releaseB.tag_name;
          if (tagB.substr(0, 1) === 'v') tagB = tagB.substr(1);
          return _semver.default.gt(tagB, tagA) ? 1 : -1;
        }); // eslint-disable-next-line prefer-destructuring

        latestRelease = sortedReleases[0];
        searchSpinner.text = 'Searching for Releases';
        const _latestRelease = latestRelease,
              assets = _latestRelease.assets;

        if (!assets || !Array.isArray(assets) || assets.length === 0) {
          throw new Error('Could not find any assets for the latest release');
        }

        const installTargets = {
          win32: [/\.exe$/],
          darwin: [/OSX.*\.zip$/, /darwin.*\.zip$/, /macOS.*\.zip$/, /mac.*\.zip$/, /\.dmg$/],
          linux: [/\.rpm$/, /\.deb$/]
        };
        possibleAssets = assets.filter(asset => {
          const targetSuffixes = installTargets[process.platform];
          var _iteratorNormalCompletion = true;
          var _didIteratorError = false;
          var _iteratorError = undefined;

          try {
            for (var _iterator = targetSuffixes[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
              const suffix = _step.value;
              if (suffix.test(asset.name)) return true;
            }
          } catch (err) {
            _didIteratorError = true;
            _iteratorError = err;
          } finally {
            try {
              if (!_iteratorNormalCompletion && _iterator.return != null) {
                _iterator.return();
              }
            } finally {
              if (_didIteratorError) {
                throw _iteratorError;
              }
            }
          }

          return false;
        });

        if (possibleAssets.length === 0) {
          throw new Error(`Failed to find any installable assets for target platform: ${`${process.platform}`.cyan}`);
        }
      });

      return function (_x2) {
        return _ref2.apply(this, arguments);
      };
    }());
    (0, _messages.info)(interactive, `Found latest release${prerelease ? ' (including prereleases)' : ''}: ${latestRelease.tag_name.cyan}`);
    let targetAsset = possibleAssets[0];

    if (possibleAssets.length > 1) {
      targetAsset = yield Promise.resolve(chooseAsset(possibleAssets));
    }

    const tmpdir = _path.default.resolve(_os.default.tmpdir(), 'forge-install');

    const pathSafeRepo = repo.replace(/[/\\]/g, '-');
    const filename = `${pathSafeRepo}-${latestRelease.tag_name}-${targetAsset.name}`;

    const fullFilePath = _path.default.resolve(tmpdir, filename);

    if (!(yield _fsExtra.default.pathExists(fullFilePath)) || (yield _fsExtra.default.stat(fullFilePath)).size !== targetAsset.size) {
      yield _fsExtra.default.mkdirs(tmpdir);
      const nuggetOpts = {
        target: filename,
        dir: tmpdir,
        resume: true,
        strictSSL: true
      };
      yield (0, _util.promisify)(nugget)(targetAsset.browser_download_url, nuggetOpts);
    }

    yield (0, _asyncOra.asyncOra)('Installing Application',
    /*#__PURE__*/
    function () {
      var _ref3 = _asyncToGenerator(function* (installSpinner) {
        const installActions = {
          win32: {
            '.exe': _installerExe.default
          },
          darwin: {
            '.zip': _installerZip.default,
            '.dmg': _installerDmg.default
          },
          linux: {
            '.deb': _installerDeb.default,
            '.rpm': _installerRpm.default
          }
        };
        const suffixFnIdent = Object.keys(installActions[process.platform]).find(suffix => targetAsset.name.endsWith(suffix));

        if (!suffixFnIdent) {
          throw new Error(`No installer to handle "${targetAsset.name}"`);
        }

        const InstallerClass = installActions[process.platform][suffixFnIdent];
        const installer = new InstallerClass();
        yield installer.install({
          installSpinner,
          filePath: fullFilePath
        });
      });

      return function (_x3) {
        return _ref3.apply(this, arguments);
      };
    }());
  });

  return function (_x) {
    return _ref.apply(this, arguments);
  };
}();

exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9hcGkvaW5zdGFsbC50cyJdLCJuYW1lcyI6WyJudWdnZXQiLCJyZXF1aXJlIiwiZCIsIkdJVEhVQl9BUEkiLCJJbnN0YWxsZXJJbXBsIiwiSW5zdGFsbGVyQmFzZSIsImludGVyYWN0aXZlIiwicHJlcmVsZWFzZSIsInJlcG8iLCJjaG9vc2VBc3NldCIsImFzeW5jT3JhIiwiRXJyb3IiLCJsYXRlc3RSZWxlYXNlIiwicG9zc2libGVBc3NldHMiLCJzZWFyY2hTcGlubmVyIiwiaW5kZXhPZiIsInJlbGVhc2VzIiwianNvbiIsImVyciIsIm1lc3NhZ2UiLCJBcnJheSIsImlzQXJyYXkiLCJsZW5ndGgiLCJmaWx0ZXIiLCJyZWxlYXNlIiwic29ydGVkUmVsZWFzZXMiLCJzb3J0IiwicmVsZWFzZUEiLCJyZWxlYXNlQiIsInRhZ0EiLCJ0YWdfbmFtZSIsInN1YnN0ciIsInRhZ0IiLCJzZW12ZXIiLCJndCIsInRleHQiLCJhc3NldHMiLCJpbnN0YWxsVGFyZ2V0cyIsIndpbjMyIiwiZGFyd2luIiwibGludXgiLCJhc3NldCIsInRhcmdldFN1ZmZpeGVzIiwicHJvY2VzcyIsInBsYXRmb3JtIiwic3VmZml4IiwidGVzdCIsIm5hbWUiLCJjeWFuIiwidGFyZ2V0QXNzZXQiLCJQcm9taXNlIiwicmVzb2x2ZSIsInRtcGRpciIsInBhdGgiLCJvcyIsInBhdGhTYWZlUmVwbyIsInJlcGxhY2UiLCJmaWxlbmFtZSIsImZ1bGxGaWxlUGF0aCIsImZzIiwicGF0aEV4aXN0cyIsInN0YXQiLCJzaXplIiwibWtkaXJzIiwibnVnZ2V0T3B0cyIsInRhcmdldCIsImRpciIsInJlc3VtZSIsInN0cmljdFNTTCIsImJyb3dzZXJfZG93bmxvYWRfdXJsIiwiaW5zdGFsbFNwaW5uZXIiLCJpbnN0YWxsQWN0aW9ucyIsIkV4ZUluc3RhbGxlciIsIlppcEluc3RhbGxlciIsIkRNR0luc3RhbGxlciIsIkRlYkluc3RhbGxlciIsIlJQTUluc3RhbGxlciIsInN1ZmZpeEZuSWRlbnQiLCJPYmplY3QiLCJrZXlzIiwiZmluZCIsImVuZHNXaXRoIiwiSW5zdGFsbGVyQ2xhc3MiLCJpbnN0YWxsZXIiLCJpbnN0YWxsIiwiZmlsZVBhdGgiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7OztBQUFBOztBQUNBOztBQUNBOztBQUNBOztBQUNBOztBQUNBOztBQUNBOztBQUNBOztBQUNBOztBQUNBOztBQUVBOztBQUNBOztBQUNBOztBQUNBOztBQUNBOztBQUVBOzs7Ozs7Ozs7O0FBRUEsTUFBTUEsTUFBTSxHQUFHQyxPQUFPLENBQUMsUUFBRCxDQUF0Qjs7QUFFQSxNQUFNQyxDQUFDLEdBQUcsb0JBQU0sd0JBQU4sQ0FBVjtBQUVBLE1BQU1DLFVBQVUsR0FBRyx3QkFBbkI7O0FBRUEsTUFBTUMsYUFBTixTQUE0QkMsc0JBQTVCLENBQTBDO0FBQUE7QUFBQTs7QUFBQSxrQ0FBUyxNQUFUO0FBQUE7O0FBQUE7Ozs7OytCQXFDM0IsV0FBTztBQUNwQkMsSUFBQUEsV0FBVyxHQUFHLEtBRE07QUFFcEJDLElBQUFBLFVBQVUsR0FBRyxLQUZPO0FBR3BCQyxJQUFBQSxJQUhvQjtBQUlwQkMsSUFBQUE7QUFKb0IsR0FBUCxFQUtPO0FBQ3BCQyx1QkFBU0osV0FBVCxHQUF1QkEsV0FBdkI7O0FBRUEsUUFBSSxPQUFPRyxXQUFQLEtBQXVCLFVBQTNCLEVBQXVDO0FBQ3JDLFlBQU0sSUFBSUUsS0FBSixDQUFVLHVEQUFWLENBQU47QUFDRDs7QUFFRCxRQUFJQyxhQUFKO0FBQ0EsUUFBSUMsY0FBdUIsR0FBRyxFQUE5QjtBQUVBLFVBQU0sd0JBQVMsMkJBQVQ7QUFBQTtBQUFBO0FBQUEsb0NBQXNDLFdBQU9DLGFBQVAsRUFBeUI7QUFDbkUsWUFBSSxDQUFDTixJQUFELElBQVNBLElBQUksQ0FBQ08sT0FBTCxDQUFhLEdBQWIsTUFBc0IsQ0FBQyxDQUFwQyxFQUF1QztBQUNyQyxnQkFBTSxJQUFJSixLQUFKLENBQVUsMkRBQVYsQ0FBTjtBQUNEOztBQUVEVCxRQUFBQSxDQUFDLENBQUMscUJBQUQsRUFBd0JNLElBQXhCLENBQUQ7QUFDQSxZQUFJUSxRQUFKOztBQUNBLFlBQUk7QUFDRkEsVUFBQUEsUUFBUSxTQUFTLE9BQU8sd0JBQU8sR0FBRWIsVUFBVyxVQUFTSyxJQUFLLFdBQWxDLENBQVAsRUFBc0RTLElBQXRELEVBQWpCO0FBQ0QsU0FGRCxDQUVFLE9BQU9DLEdBQVAsRUFBWSxDQUNaO0FBQ0Q7O0FBRUQsWUFBSSxDQUFDRixRQUFELElBQWNBLFFBQUQsQ0FBa0JHLE9BQWxCLEtBQThCLFdBQTNDLElBQTBELENBQUNDLEtBQUssQ0FBQ0MsT0FBTixDQUFjTCxRQUFkLENBQS9ELEVBQXdGO0FBQ3RGLGdCQUFNLElBQUlMLEtBQUosQ0FBVywyQ0FBMENILElBQUssMENBQTFELENBQU47QUFDRDs7QUFFRCxZQUFJUSxRQUFRLENBQUNNLE1BQVQsS0FBb0IsQ0FBeEIsRUFBMkI7QUFDekIsZ0JBQU0sSUFBSVgsS0FBSixDQUFXLGVBQWNILElBQUssbUJBQTlCLENBQU47QUFDRDs7QUFFRFEsUUFBQUEsUUFBUSxHQUFHQSxRQUFRLENBQUNPLE1BQVQsQ0FBZ0JDLE9BQU8sSUFBSSxDQUFDQSxPQUFPLENBQUNqQixVQUFULElBQXVCQSxVQUFsRCxDQUFYO0FBRUEsY0FBTWtCLGNBQWMsR0FBR1QsUUFBUSxDQUFDVSxJQUFULENBQWMsQ0FBQ0MsUUFBRCxFQUFXQyxRQUFYLEtBQXdCO0FBQzNELGNBQUlDLElBQUksR0FBR0YsUUFBUSxDQUFDRyxRQUFwQjtBQUNBLGNBQUlELElBQUksQ0FBQ0UsTUFBTCxDQUFZLENBQVosRUFBZSxDQUFmLE1BQXNCLEdBQTFCLEVBQStCRixJQUFJLEdBQUdBLElBQUksQ0FBQ0UsTUFBTCxDQUFZLENBQVosQ0FBUDtBQUMvQixjQUFJQyxJQUFJLEdBQUdKLFFBQVEsQ0FBQ0UsUUFBcEI7QUFDQSxjQUFJRSxJQUFJLENBQUNELE1BQUwsQ0FBWSxDQUFaLEVBQWUsQ0FBZixNQUFzQixHQUExQixFQUErQkMsSUFBSSxHQUFHQSxJQUFJLENBQUNELE1BQUwsQ0FBWSxDQUFaLENBQVA7QUFDL0IsaUJBQVFFLGdCQUFPQyxFQUFQLENBQVVGLElBQVYsRUFBZ0JILElBQWhCLElBQXdCLENBQXhCLEdBQTRCLENBQUMsQ0FBckM7QUFDRCxTQU5zQixDQUF2QixDQXZCbUUsQ0E4Qm5FOztBQUNBakIsUUFBQUEsYUFBYSxHQUFHYSxjQUFjLENBQUMsQ0FBRCxDQUE5QjtBQUVBWCxRQUFBQSxhQUFhLENBQUNxQixJQUFkLEdBQXFCLHdCQUFyQjtBQWpDbUUsK0JBbUNoRHZCLGFBbkNnRDtBQUFBLGNBbUMzRHdCLE1BbkMyRCxrQkFtQzNEQSxNQW5DMkQ7O0FBb0NuRSxZQUFJLENBQUNBLE1BQUQsSUFBVyxDQUFDaEIsS0FBSyxDQUFDQyxPQUFOLENBQWNlLE1BQWQsQ0FBWixJQUFxQ0EsTUFBTSxDQUFDZCxNQUFQLEtBQWtCLENBQTNELEVBQThEO0FBQzVELGdCQUFNLElBQUlYLEtBQUosQ0FBVSxrREFBVixDQUFOO0FBQ0Q7O0FBRUQsY0FBTTBCLGNBRUwsR0FBRztBQUNGQyxVQUFBQSxLQUFLLEVBQUUsQ0FBQyxRQUFELENBREw7QUFFRkMsVUFBQUEsTUFBTSxFQUFFLENBQUMsYUFBRCxFQUFnQixnQkFBaEIsRUFBa0MsZUFBbEMsRUFBbUQsYUFBbkQsRUFBa0UsUUFBbEUsQ0FGTjtBQUdGQyxVQUFBQSxLQUFLLEVBQUUsQ0FBQyxRQUFELEVBQVcsUUFBWDtBQUhMLFNBRko7QUFRQTNCLFFBQUFBLGNBQWMsR0FBR3VCLE1BQU0sQ0FBQ2IsTUFBUCxDQUFla0IsS0FBRCxJQUFXO0FBQ3hDLGdCQUFNQyxjQUFjLEdBQUdMLGNBQWMsQ0FBQ00sT0FBTyxDQUFDQyxRQUFULENBQXJDO0FBRHdDO0FBQUE7QUFBQTs7QUFBQTtBQUV4QyxpQ0FBcUJGLGNBQXJCLDhIQUFxQztBQUFBLG9CQUExQkcsTUFBMEI7QUFDbkMsa0JBQUlBLE1BQU0sQ0FBQ0MsSUFBUCxDQUFZTCxLQUFLLENBQUNNLElBQWxCLENBQUosRUFBNkIsT0FBTyxJQUFQO0FBQzlCO0FBSnVDO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7O0FBS3hDLGlCQUFPLEtBQVA7QUFDRCxTQU5nQixDQUFqQjs7QUFRQSxZQUFJbEMsY0FBYyxDQUFDUyxNQUFmLEtBQTBCLENBQTlCLEVBQWlDO0FBQy9CLGdCQUFNLElBQUlYLEtBQUosQ0FBVyw4REFBOEQsR0FBRWdDLE9BQU8sQ0FBQ0MsUUFBUyxFQUFwQixDQUFzQkksSUFBSyxFQUFuRyxDQUFOO0FBQ0Q7QUFDRixPQTNESzs7QUFBQTtBQUFBO0FBQUE7QUFBQSxRQUFOO0FBNkRBLHdCQUFLMUMsV0FBTCxFQUFtQix1QkFBc0JDLFVBQVUsR0FBRywwQkFBSCxHQUFnQyxFQUFHLEtBQUlLLGFBQWEsQ0FBQ2tCLFFBQWQsQ0FBdUJrQixJQUFLLEVBQXRIO0FBRUEsUUFBSUMsV0FBVyxHQUFHcEMsY0FBYyxDQUFDLENBQUQsQ0FBaEM7O0FBQ0EsUUFBSUEsY0FBYyxDQUFDUyxNQUFmLEdBQXdCLENBQTVCLEVBQStCO0FBQzdCMkIsTUFBQUEsV0FBVyxTQUFTQyxPQUFPLENBQUNDLE9BQVIsQ0FBZ0IxQyxXQUFXLENBQUNJLGNBQUQsQ0FBM0IsQ0FBcEI7QUFDRDs7QUFFRCxVQUFNdUMsTUFBTSxHQUFHQyxjQUFLRixPQUFMLENBQWFHLFlBQUdGLE1BQUgsRUFBYixFQUEwQixlQUExQixDQUFmOztBQUNBLFVBQU1HLFlBQVksR0FBRy9DLElBQUksQ0FBQ2dELE9BQUwsQ0FBYSxRQUFiLEVBQXVCLEdBQXZCLENBQXJCO0FBQ0EsVUFBTUMsUUFBUSxHQUFJLEdBQUVGLFlBQWEsSUFBRzNDLGFBQWEsQ0FBQ2tCLFFBQVMsSUFBR21CLFdBQVcsQ0FBQ0YsSUFBSyxFQUEvRTs7QUFFQSxVQUFNVyxZQUFZLEdBQUdMLGNBQUtGLE9BQUwsQ0FBYUMsTUFBYixFQUFxQkssUUFBckIsQ0FBckI7O0FBQ0EsUUFBSSxRQUFPRSxpQkFBR0MsVUFBSCxDQUFjRixZQUFkLENBQVAsS0FDRyxPQUFPQyxpQkFBR0UsSUFBSCxDQUFRSCxZQUFSLENBQVAsRUFBOEJJLElBQTlCLEtBQXVDYixXQUFXLENBQUNhLElBRDFELEVBQ2dFO0FBQzlELFlBQU1ILGlCQUFHSSxNQUFILENBQVVYLE1BQVYsQ0FBTjtBQUVBLFlBQU1ZLFVBQVUsR0FBRztBQUNqQkMsUUFBQUEsTUFBTSxFQUFFUixRQURTO0FBRWpCUyxRQUFBQSxHQUFHLEVBQUVkLE1BRlk7QUFHakJlLFFBQUFBLE1BQU0sRUFBRSxJQUhTO0FBSWpCQyxRQUFBQSxTQUFTLEVBQUU7QUFKTSxPQUFuQjtBQU1BLFlBQU0scUJBQVVwRSxNQUFWLEVBQWtCaUQsV0FBVyxDQUFDb0Isb0JBQTlCLEVBQW9ETCxVQUFwRCxDQUFOO0FBQ0Q7O0FBRUQsVUFBTSx3QkFBUyx3QkFBVDtBQUFBO0FBQUE7QUFBQSxvQ0FBbUMsV0FBT00sY0FBUCxFQUEwQjtBQUNqRSxjQUFNQyxjQUlMLEdBQUc7QUFDRmpDLFVBQUFBLEtBQUssRUFBRTtBQUNMLG9CQUFRa0M7QUFESCxXQURMO0FBSUZqQyxVQUFBQSxNQUFNLEVBQUU7QUFDTixvQkFBUWtDLHFCQURGO0FBRU4sb0JBQVFDO0FBRkYsV0FKTjtBQVFGbEMsVUFBQUEsS0FBSyxFQUFFO0FBQ0wsb0JBQVFtQyxxQkFESDtBQUVMLG9CQUFRQztBQUZIO0FBUkwsU0FKSjtBQWtCQSxjQUFNQyxhQUFhLEdBQUdDLE1BQU0sQ0FBQ0MsSUFBUCxDQUFZUixjQUFjLENBQUM1QixPQUFPLENBQUNDLFFBQVQsQ0FBMUIsRUFDbkJvQyxJQURtQixDQUNkbkMsTUFBTSxJQUFJSSxXQUFXLENBQUNGLElBQVosQ0FBaUJrQyxRQUFqQixDQUEwQnBDLE1BQTFCLENBREksQ0FBdEI7O0FBRUEsWUFBSSxDQUFDZ0MsYUFBTCxFQUFvQjtBQUNsQixnQkFBTSxJQUFJbEUsS0FBSixDQUFXLDJCQUEwQnNDLFdBQVcsQ0FBQ0YsSUFBSyxHQUF0RCxDQUFOO0FBQ0Q7O0FBQ0QsY0FBTW1DLGNBQWMsR0FBR1gsY0FBYyxDQUFDNUIsT0FBTyxDQUFDQyxRQUFULENBQWQsQ0FBaUNpQyxhQUFqQyxDQUF2QjtBQUNBLGNBQU1NLFNBQVMsR0FBRyxJQUFJRCxjQUFKLEVBQWxCO0FBQ0EsY0FBTUMsU0FBUyxDQUFDQyxPQUFWLENBQWtCO0FBQUVkLFVBQUFBLGNBQUY7QUFBa0JlLFVBQUFBLFFBQVEsRUFBRTNCO0FBQTVCLFNBQWxCLENBQU47QUFDRCxPQTNCSzs7QUFBQTtBQUFBO0FBQUE7QUFBQSxRQUFOO0FBNEJELEciLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgJ2NvbG9ycyc7XG5pbXBvcnQgeyBhc3luY09yYSB9IGZyb20gJ0BlbGVjdHJvbi1mb3JnZS9hc3luYy1vcmEnO1xuaW1wb3J0IEluc3RhbGxlckJhc2UgZnJvbSAnQGVsZWN0cm9uLWZvcmdlL2luc3RhbGxlci1iYXNlJztcbmltcG9ydCBkZWJ1ZyBmcm9tICdkZWJ1Zyc7XG5pbXBvcnQgZmV0Y2ggZnJvbSAnbm9kZS1mZXRjaCc7XG5pbXBvcnQgZnMgZnJvbSAnZnMtZXh0cmEnO1xuaW1wb3J0IG9zIGZyb20gJ29zJztcbmltcG9ydCBwYXRoIGZyb20gJ3BhdGgnO1xuaW1wb3J0IHsgcHJvbWlzaWZ5IH0gZnJvbSAndXRpbCc7XG5pbXBvcnQgc2VtdmVyIGZyb20gJ3NlbXZlcic7XG5cbmltcG9ydCBETUdJbnN0YWxsZXIgZnJvbSAnQGVsZWN0cm9uLWZvcmdlL2luc3RhbGxlci1kbWcnO1xuaW1wb3J0IFppcEluc3RhbGxlciBmcm9tICdAZWxlY3Ryb24tZm9yZ2UvaW5zdGFsbGVyLXppcCc7XG5pbXBvcnQgRGViSW5zdGFsbGVyIGZyb20gJ0BlbGVjdHJvbi1mb3JnZS9pbnN0YWxsZXItZGViJztcbmltcG9ydCBSUE1JbnN0YWxsZXIgZnJvbSAnQGVsZWN0cm9uLWZvcmdlL2luc3RhbGxlci1ycG0nO1xuaW1wb3J0IEV4ZUluc3RhbGxlciBmcm9tICdAZWxlY3Ryb24tZm9yZ2UvaW5zdGFsbGVyLWV4ZSc7XG5cbmltcG9ydCB7IGluZm8gfSBmcm9tICcuLi91dGlsL21lc3NhZ2VzJztcblxuY29uc3QgbnVnZ2V0ID0gcmVxdWlyZSgnbnVnZ2V0Jyk7XG5cbmNvbnN0IGQgPSBkZWJ1ZygnZWxlY3Ryb24tZm9yZ2U6aW5zdGFsbCcpO1xuXG5jb25zdCBHSVRIVUJfQVBJID0gJ2h0dHBzOi8vYXBpLmdpdGh1Yi5jb20nO1xuXG5jbGFzcyBJbnN0YWxsZXJJbXBsIGV4dGVuZHMgSW5zdGFsbGVyQmFzZSB7IG5hbWUgPSAnaW1wbCc7IH1cblxuaW50ZXJmYWNlIFJlbGVhc2Uge1xuICAvLyBlc2xpbnQtZGlzYWJsZS1uZXh0LWxpbmUgY2FtZWxjYXNlXG4gIHRhZ19uYW1lOiBzdHJpbmc7XG4gIHByZXJlbGVhc2U6IGJvb2xlYW47XG4gIGFzc2V0czogQXNzZXRbXTtcbn1cblxuZXhwb3J0IGludGVyZmFjZSBBc3NldCB7XG4gIGlkOiBzdHJpbmc7XG4gIG5hbWU6IHN0cmluZztcbiAgc2l6ZTogbnVtYmVyO1xuICAvLyBlc2xpbnQtZGlzYWJsZS1uZXh0LWxpbmUgY2FtZWxjYXNlXG4gIGJyb3dzZXJfZG93bmxvYWRfdXJsOiBzdHJpbmc7XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgSW5zdGFsbE9wdGlvbnMge1xuICAvKipcbiAgICogV2hldGhlciB0byB1c2Ugc2Vuc2libGUgZGVmYXVsdHMgb3IgcHJvbXB0IHRoZSB1c2VyIHZpc3VhbGx5XG4gICAqL1xuICBpbnRlcmFjdGl2ZT86IGJvb2xlYW47XG4gIC8qKlxuICAgKiBXaGV0aGVyIHRvIGluc3RhbGwgcHJlcmVsZWFzZSB2ZXJzaW9uc1xuICAgKi9cbiAgcHJlcmVsZWFzZT86IGJvb2xlYW47XG4gIC8qKlxuICAgKiBUaGUgR2l0SHViIHJlcG9zaXRvcnkgdG8gaW5zdGFsbCBmcm9tLCBpbiB0aGUgZm9ybWF0IG93bmVyL25hbWVcbiAgICovXG4gIHJlcG86IHN0cmluZztcbiAgLyoqXG4gICAqIEEgZnVuY3Rpb24gdGhhdCBtdXN0IHJldHVybiB0aGUgYXNzZXQgdG8gdXNlL2luc3RhbGwgZnJvbSBhIHByb3ZpZGVkIGFycmF5IG9mIGNvbXBhdGlibGVcbiAgICogR2l0SHViIGFzc2V0cy5cbiAgICovXG4gIGNob29zZUFzc2V0OiAoYXNzZXRzOiBBc3NldFtdKSA9PiBQcm9taXNlPEFzc2V0PiB8IEFzc2V0O1xufVxuXG5leHBvcnQgZGVmYXVsdCBhc3luYyAoe1xuICBpbnRlcmFjdGl2ZSA9IGZhbHNlLFxuICBwcmVyZWxlYXNlID0gZmFsc2UsXG4gIHJlcG8sXG4gIGNob29zZUFzc2V0LFxufTogSW5zdGFsbE9wdGlvbnMpID0+IHtcbiAgYXN5bmNPcmEuaW50ZXJhY3RpdmUgPSBpbnRlcmFjdGl2ZTtcblxuICBpZiAodHlwZW9mIGNob29zZUFzc2V0ICE9PSAnZnVuY3Rpb24nKSB7XG4gICAgdGhyb3cgbmV3IEVycm9yKCdFeHBlY3RlZCBjaG9vc2VBc3NldCB0byBiZSBhIGZ1bmN0aW9uIGluIGluc3RhbGwgY2FsbCcpO1xuICB9XG5cbiAgbGV0IGxhdGVzdFJlbGVhc2UhOiBSZWxlYXNlO1xuICBsZXQgcG9zc2libGVBc3NldHM6IEFzc2V0W10gPSBbXTtcblxuICBhd2FpdCBhc3luY09yYSgnU2VhcmNoaW5nIGZvciBBcHBsaWNhdGlvbicsIGFzeW5jIChzZWFyY2hTcGlubmVyKSA9PiB7XG4gICAgaWYgKCFyZXBvIHx8IHJlcG8uaW5kZXhPZignLycpID09PSAtMSkge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKCdJbnZhbGlkIHJlcG9zaXRvcnkgbmFtZSwgbXVzdCBiZSBpbiB0aGUgZm9ybWF0IG93bmVyL25hbWUnKTtcbiAgICB9XG5cbiAgICBkKCdzZWFyY2hpbmcgZm9yIHJlcG86JywgcmVwbyk7XG4gICAgbGV0IHJlbGVhc2VzITogUmVsZWFzZVtdO1xuICAgIHRyeSB7XG4gICAgICByZWxlYXNlcyA9IGF3YWl0IChhd2FpdCBmZXRjaChgJHtHSVRIVUJfQVBJfS9yZXBvcy8ke3JlcG99L3JlbGVhc2VzYCkpLmpzb24oKTtcbiAgICB9IGNhdGNoIChlcnIpIHtcbiAgICAgIC8vIElnbm9yZSBlcnJvclxuICAgIH1cblxuICAgIGlmICghcmVsZWFzZXMgfHwgKHJlbGVhc2VzIGFzIGFueSkubWVzc2FnZSA9PT0gJ05vdCBGb3VuZCcgfHwgIUFycmF5LmlzQXJyYXkocmVsZWFzZXMpKSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoYEZhaWxlZCB0byBmaW5kIHJlbGVhc2VzIGZvciByZXBvc2l0b3J5IFwiJHtyZXBvfVwiLiAgUGxlYXNlIGNoZWNrIHRoZSBuYW1lIGFuZCB0cnkgYWdhaW4uYCk7XG4gICAgfVxuXG4gICAgaWYgKHJlbGVhc2VzLmxlbmd0aCA9PT0gMCkge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKGBSZXBvc2l0b3J5IFwiJHtyZXBvfVwiIGhhcyBubyByZWxlYXNlc2ApO1xuICAgIH1cblxuICAgIHJlbGVhc2VzID0gcmVsZWFzZXMuZmlsdGVyKHJlbGVhc2UgPT4gIXJlbGVhc2UucHJlcmVsZWFzZSB8fCBwcmVyZWxlYXNlKTtcblxuICAgIGNvbnN0IHNvcnRlZFJlbGVhc2VzID0gcmVsZWFzZXMuc29ydCgocmVsZWFzZUEsIHJlbGVhc2VCKSA9PiB7XG4gICAgICBsZXQgdGFnQSA9IHJlbGVhc2VBLnRhZ19uYW1lO1xuICAgICAgaWYgKHRhZ0Euc3Vic3RyKDAsIDEpID09PSAndicpIHRhZ0EgPSB0YWdBLnN1YnN0cigxKTtcbiAgICAgIGxldCB0YWdCID0gcmVsZWFzZUIudGFnX25hbWU7XG4gICAgICBpZiAodGFnQi5zdWJzdHIoMCwgMSkgPT09ICd2JykgdGFnQiA9IHRhZ0Iuc3Vic3RyKDEpO1xuICAgICAgcmV0dXJuIChzZW12ZXIuZ3QodGFnQiwgdGFnQSkgPyAxIDogLTEpO1xuICAgIH0pO1xuICAgIC8vIGVzbGludC1kaXNhYmxlLW5leHQtbGluZSBwcmVmZXItZGVzdHJ1Y3R1cmluZ1xuICAgIGxhdGVzdFJlbGVhc2UgPSBzb3J0ZWRSZWxlYXNlc1swXTtcblxuICAgIHNlYXJjaFNwaW5uZXIudGV4dCA9ICdTZWFyY2hpbmcgZm9yIFJlbGVhc2VzJztcblxuICAgIGNvbnN0IHsgYXNzZXRzIH0gPSBsYXRlc3RSZWxlYXNlO1xuICAgIGlmICghYXNzZXRzIHx8ICFBcnJheS5pc0FycmF5KGFzc2V0cykgfHwgYXNzZXRzLmxlbmd0aCA9PT0gMCkge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKCdDb3VsZCBub3QgZmluZCBhbnkgYXNzZXRzIGZvciB0aGUgbGF0ZXN0IHJlbGVhc2UnKTtcbiAgICB9XG5cbiAgICBjb25zdCBpbnN0YWxsVGFyZ2V0czoge1xuICAgICAgW2tleTogc3RyaW5nXTogUmVnRXhwW107XG4gICAgfSA9IHtcbiAgICAgIHdpbjMyOiBbL1xcLmV4ZSQvXSxcbiAgICAgIGRhcndpbjogWy9PU1guKlxcLnppcCQvLCAvZGFyd2luLipcXC56aXAkLywgL21hY09TLipcXC56aXAkLywgL21hYy4qXFwuemlwJC8sIC9cXC5kbWckL10sXG4gICAgICBsaW51eDogWy9cXC5ycG0kLywgL1xcLmRlYiQvXSxcbiAgICB9O1xuXG4gICAgcG9zc2libGVBc3NldHMgPSBhc3NldHMuZmlsdGVyKChhc3NldCkgPT4ge1xuICAgICAgY29uc3QgdGFyZ2V0U3VmZml4ZXMgPSBpbnN0YWxsVGFyZ2V0c1twcm9jZXNzLnBsYXRmb3JtXTtcbiAgICAgIGZvciAoY29uc3Qgc3VmZml4IG9mIHRhcmdldFN1ZmZpeGVzKSB7XG4gICAgICAgIGlmIChzdWZmaXgudGVzdChhc3NldC5uYW1lKSkgcmV0dXJuIHRydWU7XG4gICAgICB9XG4gICAgICByZXR1cm4gZmFsc2U7XG4gICAgfSk7XG5cbiAgICBpZiAocG9zc2libGVBc3NldHMubGVuZ3RoID09PSAwKSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoYEZhaWxlZCB0byBmaW5kIGFueSBpbnN0YWxsYWJsZSBhc3NldHMgZm9yIHRhcmdldCBwbGF0Zm9ybTogJHtgJHtwcm9jZXNzLnBsYXRmb3JtfWAuY3lhbn1gKTtcbiAgICB9XG4gIH0pO1xuXG4gIGluZm8oaW50ZXJhY3RpdmUsIGBGb3VuZCBsYXRlc3QgcmVsZWFzZSR7cHJlcmVsZWFzZSA/ICcgKGluY2x1ZGluZyBwcmVyZWxlYXNlcyknIDogJyd9OiAke2xhdGVzdFJlbGVhc2UudGFnX25hbWUuY3lhbn1gKTtcblxuICBsZXQgdGFyZ2V0QXNzZXQgPSBwb3NzaWJsZUFzc2V0c1swXTtcbiAgaWYgKHBvc3NpYmxlQXNzZXRzLmxlbmd0aCA+IDEpIHtcbiAgICB0YXJnZXRBc3NldCA9IGF3YWl0IFByb21pc2UucmVzb2x2ZShjaG9vc2VBc3NldChwb3NzaWJsZUFzc2V0cykpO1xuICB9XG5cbiAgY29uc3QgdG1wZGlyID0gcGF0aC5yZXNvbHZlKG9zLnRtcGRpcigpLCAnZm9yZ2UtaW5zdGFsbCcpO1xuICBjb25zdCBwYXRoU2FmZVJlcG8gPSByZXBvLnJlcGxhY2UoL1svXFxcXF0vZywgJy0nKTtcbiAgY29uc3QgZmlsZW5hbWUgPSBgJHtwYXRoU2FmZVJlcG99LSR7bGF0ZXN0UmVsZWFzZS50YWdfbmFtZX0tJHt0YXJnZXRBc3NldC5uYW1lfWA7XG5cbiAgY29uc3QgZnVsbEZpbGVQYXRoID0gcGF0aC5yZXNvbHZlKHRtcGRpciwgZmlsZW5hbWUpO1xuICBpZiAoIWF3YWl0IGZzLnBhdGhFeGlzdHMoZnVsbEZpbGVQYXRoKVxuICAgICAgfHwgKGF3YWl0IGZzLnN0YXQoZnVsbEZpbGVQYXRoKSkuc2l6ZSAhPT0gdGFyZ2V0QXNzZXQuc2l6ZSkge1xuICAgIGF3YWl0IGZzLm1rZGlycyh0bXBkaXIpO1xuXG4gICAgY29uc3QgbnVnZ2V0T3B0cyA9IHtcbiAgICAgIHRhcmdldDogZmlsZW5hbWUsXG4gICAgICBkaXI6IHRtcGRpcixcbiAgICAgIHJlc3VtZTogdHJ1ZSxcbiAgICAgIHN0cmljdFNTTDogdHJ1ZSxcbiAgICB9O1xuICAgIGF3YWl0IHByb21pc2lmeShudWdnZXQpKHRhcmdldEFzc2V0LmJyb3dzZXJfZG93bmxvYWRfdXJsLCBudWdnZXRPcHRzKTtcbiAgfVxuXG4gIGF3YWl0IGFzeW5jT3JhKCdJbnN0YWxsaW5nIEFwcGxpY2F0aW9uJywgYXN5bmMgKGluc3RhbGxTcGlubmVyKSA9PiB7XG4gICAgY29uc3QgaW5zdGFsbEFjdGlvbnM6IHtcbiAgICAgIFtrZXk6IHN0cmluZ106IHtcbiAgICAgICAgW2tleTogc3RyaW5nXTogdHlwZW9mIEluc3RhbGxlckltcGw7XG4gICAgICB9O1xuICAgIH0gPSB7XG4gICAgICB3aW4zMjoge1xuICAgICAgICAnLmV4ZSc6IEV4ZUluc3RhbGxlcixcbiAgICAgIH0sXG4gICAgICBkYXJ3aW46IHtcbiAgICAgICAgJy56aXAnOiBaaXBJbnN0YWxsZXIsXG4gICAgICAgICcuZG1nJzogRE1HSW5zdGFsbGVyLFxuICAgICAgfSxcbiAgICAgIGxpbnV4OiB7XG4gICAgICAgICcuZGViJzogRGViSW5zdGFsbGVyLFxuICAgICAgICAnLnJwbSc6IFJQTUluc3RhbGxlcixcbiAgICAgIH0sXG4gICAgfTtcblxuICAgIGNvbnN0IHN1ZmZpeEZuSWRlbnQgPSBPYmplY3Qua2V5cyhpbnN0YWxsQWN0aW9uc1twcm9jZXNzLnBsYXRmb3JtXSlcbiAgICAgIC5maW5kKHN1ZmZpeCA9PiB0YXJnZXRBc3NldC5uYW1lLmVuZHNXaXRoKHN1ZmZpeCkpO1xuICAgIGlmICghc3VmZml4Rm5JZGVudCkge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKGBObyBpbnN0YWxsZXIgdG8gaGFuZGxlIFwiJHt0YXJnZXRBc3NldC5uYW1lfVwiYCk7XG4gICAgfVxuICAgIGNvbnN0IEluc3RhbGxlckNsYXNzID0gaW5zdGFsbEFjdGlvbnNbcHJvY2Vzcy5wbGF0Zm9ybV1bc3VmZml4Rm5JZGVudF07XG4gICAgY29uc3QgaW5zdGFsbGVyID0gbmV3IEluc3RhbGxlckNsYXNzKCk7XG4gICAgYXdhaXQgaW5zdGFsbGVyLmluc3RhbGwoeyBpbnN0YWxsU3Bpbm5lciwgZmlsZVBhdGg6IGZ1bGxGaWxlUGF0aCB9KTtcbiAgfSk7XG59O1xuIl19