import 'colors';
export interface Asset {
    id: string;
    name: string;
    size: number;
    browser_download_url: string;
}
export interface InstallOptions {
    /**
     * Whether to use sensible defaults or prompt the user visually
     */
    interactive?: boolean;
    /**
     * Whether to install prerelease versions
     */
    prerelease?: boolean;
    /**
     * The GitHub repository to install from, in the format owner/name
     */
    repo: string;
    /**
     * A function that must return the asset to use/install from a provided array of compatible
     * GitHub assets.
     */
    chooseAsset: (assets: Asset[]) => Promise<Asset> | Asset;
}
declare const _default: ({ interactive, prerelease, repo, chooseAsset, }: InstallOptions) => Promise<void>;
export default _default;
