"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

require("source-map-support/register");

var _asyncOra = require("@electron-forge/async-ora");

var _debug = _interopRequireDefault(require("debug"));

var _initCustom = _interopRequireDefault(require("./init-scripts/init-custom"));

var _initDirectory = _interopRequireDefault(require("./init-scripts/init-directory"));

var _initGit = _interopRequireDefault(require("./init-scripts/init-git"));

var _initNpm = _interopRequireDefault(require("./init-scripts/init-npm"));

var _initStarterFiles = _interopRequireDefault(require("./init-scripts/init-starter-files"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

const d = (0, _debug.default)('electron-forge:init');

var _default =
/*#__PURE__*/
function () {
  var _ref = _asyncToGenerator(function* ({
    dir = process.cwd(),
    interactive = false,
    copyCIFiles = false,
    force = false,
    template
  }) {
    _asyncOra.asyncOra.interactive = interactive;
    d(`Initializing in: ${dir}`);
    yield (0, _initDirectory.default)(dir, force);
    yield (0, _initGit.default)(dir);
    yield (0, _initStarterFiles.default)(dir, {
      copyCIFiles
    });
    yield (0, _initNpm.default)(dir);

    if (template) {
      yield (0, _initCustom.default)(dir, template);
    }
  });

  return function (_x) {
    return _ref.apply(this, arguments);
  };
}();

exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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