"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.copy = void 0;

require("source-map-support/register");

var _asyncOra = require("@electron-forge/async-ora");

var _debug = _interopRequireDefault(require("debug"));

var _fsExtra = _interopRequireDefault(require("fs-extra"));

var _path = _interopRequireDefault(require("path"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

const d = (0, _debug.default)('electron-forge:init:starter-files');

const copy =
/*#__PURE__*/
function () {
  var _ref = _asyncToGenerator(function* (source, target) {
    d(`copying "${source}" --> "${target}"`);
    yield _fsExtra.default.copy(source, target);
  });

  return function copy(_x, _x2) {
    return _ref.apply(this, arguments);
  };
}();

exports.copy = copy;

var _default =
/*#__PURE__*/
function () {
  var _ref2 = _asyncToGenerator(function* (dir, {
    copyCIFiles
  }) {
    yield (0, _asyncOra.asyncOra)('Copying Starter Files',
    /*#__PURE__*/
    _asyncToGenerator(function* () {
      const tmplPath = _path.default.resolve(__dirname, '../../../tmpl');

      d('creating directory:', _path.default.resolve(dir, 'src'));
      yield _fsExtra.default.mkdirs(_path.default.resolve(dir, 'src'));
      const rootFiles = ['_gitignore'];
      if (copyCIFiles) rootFiles.push(...['_travis.yml', '_appveyor.yml']);
      const srcFiles = ['index.css', 'index.js', 'index.html'];

      for (var _i = 0, _rootFiles = rootFiles; _i < _rootFiles.length; _i++) {
        const file = _rootFiles[_i];
        yield copy(_path.default.resolve(tmplPath, file), _path.default.resolve(dir, file.replace(/^_/, '.')));
      }

      for (var _i2 = 0, _srcFiles = srcFiles; _i2 < _srcFiles.length; _i2++) {
        const file = _srcFiles[_i2];
        yield copy(_path.default.resolve(tmplPath, file), _path.default.resolve(dir, 'src', file));
      }
    }));
  });

  return function (_x3, _x4) {
    return _ref2.apply(this, arguments);
  };
}();

exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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