"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.siblingDep = siblingDep;
exports.default = exports.exactDevDeps = exports.devDeps = exports.deps = void 0;

require("source-map-support/register");

var _asyncOra = require("@electron-forge/async-ora");

var _debug = _interopRequireDefault(require("debug"));

var _fsExtra = _interopRequireDefault(require("fs-extra"));

var _path = _interopRequireDefault(require("path"));

var _determineAuthor = _interopRequireDefault(require("../../util/determine-author"));

var _installDependencies = _interopRequireWildcard(require("../../util/install-dependencies"));

var _readPackageJson = require("../../util/read-package-json");

var _forgeConfig = require("../../util/forge-config");

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

const d = (0, _debug.default)('electron-forge:init:npm');

const corePackage = _fsExtra.default.readJsonSync(_path.default.resolve(__dirname, '../../../package.json'));

function siblingDep(name) {
  return `@electron-forge/${name}@${corePackage.version}`;
}

const deps = ['electron-squirrel-startup'];
exports.deps = deps;
const devDeps = [siblingDep('cli'), siblingDep('maker-squirrel'), siblingDep('maker-zip'), siblingDep('maker-deb'), siblingDep('maker-rpm')];
exports.devDeps = devDeps;
const exactDevDeps = ['electron'];
exports.exactDevDeps = exactDevDeps;

var _default =
/*#__PURE__*/
function () {
  var _ref = _asyncToGenerator(function* (dir) {
    yield (0, _asyncOra.asyncOra)('Initializing NPM Module',
    /*#__PURE__*/
    _asyncToGenerator(function* () {
      const packageJSON = yield (0, _readPackageJson.readRawPackageJson)(_path.default.resolve(__dirname, '../../../tmpl')); // eslint-disable-next-line no-multi-assign

      packageJSON.productName = packageJSON.name = _path.default.basename(dir).toLowerCase();
      packageJSON.author = yield (0, _determineAuthor.default)(dir);
      (0, _forgeConfig.setInitialForgeConfig)(packageJSON);
      packageJSON.scripts.lint = 'echo "No linting configured"';
      d('writing package.json to:', dir);
      yield _fsExtra.default.writeJson(_path.default.resolve(dir, 'package.json'), packageJSON, {
        spaces: 2
      });
    }));
    yield (0, _asyncOra.asyncOra)('Installing NPM Dependencies',
    /*#__PURE__*/
    _asyncToGenerator(function* () {
      d('installing dependencies');
      yield (0, _installDependencies.default)(dir, deps);
      d('installing devDependencies');
      yield (0, _installDependencies.default)(dir, devDeps, _installDependencies.DepType.DEV);
      d('installing exact devDependencies');

      for (var _i = 0, _exactDevDeps = exactDevDeps; _i < _exactDevDeps.length; _i++) {
        const packageName = _exactDevDeps[_i];
        yield (0, _installDependencies.default)(dir, [packageName], _installDependencies.DepType.DEV, _installDependencies.DepVersionRestriction.EXACT);
      }
    }));
  });

  return function (_x) {
    return _ref.apply(this, arguments);
  };
}();

exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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