"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

require("source-map-support/register");

var _asyncOra = require("@electron-forge/async-ora");

var _child_process = require("child_process");

var _debug = _interopRequireDefault(require("debug"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

const d = (0, _debug.default)('electron-forge:init:git');

var _default =
/*#__PURE__*/
function () {
  var _ref = _asyncToGenerator(function* (dir) {
    yield (0, _asyncOra.asyncOra)('Initializing Git Repository',
    /*#__PURE__*/
    _asyncToGenerator(function* () {
      yield new Promise((resolve, reject) => {
        (0, _child_process.exec)('git rev-parse --show-toplevel', {
          cwd: dir
        }, err => {
          if (err) {
            // not run within a Git repository
            d('executing "git init" in directory:', dir);
            (0, _child_process.exec)('git init', {
              cwd: dir
            }, initErr => initErr ? reject(initErr) : resolve());
          } else {
            d('.git directory already exists, skipping git initialization');
            resolve();
          }
        });
      });
    }));
  });

  return function (_x) {
    return _ref.apply(this, arguments);
  };
}();

exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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