"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

require("source-map-support/register");

var _asyncOra = require("@electron-forge/async-ora");

var _debug = _interopRequireDefault(require("debug"));

var _fsExtra = _interopRequireDefault(require("fs-extra"));

var _logSymbols = _interopRequireDefault(require("log-symbols"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

const d = (0, _debug.default)('electron-forge:init:directory');

var _default =
/*#__PURE__*/
function () {
  var _ref = _asyncToGenerator(function* (dir, force = false) {
    yield (0, _asyncOra.asyncOra)('Initializing Project Directory',
    /*#__PURE__*/
    function () {
      var _ref2 = _asyncToGenerator(function* (initSpinner) {
        d('creating directory:', dir);
        yield _fsExtra.default.mkdirs(dir);
        const files = yield _fsExtra.default.readdir(dir);

        if (files.length !== 0) {
          d(`found ${files.length} files in the directory.  warning the user`);

          if (force) {
            initSpinner.warn(`The specified path "${dir}" is not empty. "force" was set to true, so proceeding to initialize. Files may be overwritten`);
          } else {
            initSpinner.stop(_logSymbols.default.warning);
            throw new Error(`The specified path: "${dir}" is not empty.  Please ensure it is empty before initializing a new project`);
          }
        }
      });

      return function (_x2) {
        return _ref2.apply(this, arguments);
      };
    }());
  });

  return function (_x) {
    return _ref.apply(this, arguments);
  };
}();

exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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