"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

require("source-map-support/register");

var _asyncOra = require("@electron-forge/async-ora");

var _debug = _interopRequireDefault(require("debug"));

var _resolvePackage = _interopRequireDefault(require("resolve-package"));

var _installDependencies = _interopRequireWildcard(require("../../util/install-dependencies"));

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

const d = (0, _debug.default)('electron-forge:init:custom');

var _default =
/*#__PURE__*/
function () {
  var _ref = _asyncToGenerator(function* (dir, template) {
    let templateModulePath;
    yield (0, _asyncOra.asyncOra)(`Locating custom template: "${template}"`,
    /*#__PURE__*/
    _asyncToGenerator(function* () {
      try {
        templateModulePath = yield (0, _resolvePackage.default)(`electron-forge-template-${template}`);
        d('using global template');
      } catch (err) {
        try {
          templateModulePath = yield (0, _resolvePackage.default)(`@electron-forge/template-${template}`);
          d('using global template');
        } catch (err2) {
          try {
            templateModulePath = require.resolve(`electron-forge-template-${template}`);
            d('using local template');
          } catch (err3) {
            try {
              templateModulePath = require.resolve(`@electron-forge/template-${template}`);
              d('using local template');
            } catch (err4) {
              try {
                templateModulePath = require.resolve(template);
                d('using absolute template');
              } catch (err5) {
                throw new Error(`Failed to locate custom template: "${template}"\n\nTry \`npm install -g @electron-forge-template-${template}\``);
              }
            }
          }
        }
      }
    })); // eslint-disable-next-line import/no-dynamic-require, global-require

    let templateModule = require(templateModulePath);

    templateModule = templateModule.default || templateModule;
    yield (0, _asyncOra.asyncOra)('Installing Template Dependencies',
    /*#__PURE__*/
    _asyncToGenerator(function* () {
      d('installing dependencies');
      yield (0, _installDependencies.default)(dir, templateModule.dependencies || []);
      d('installing devDependencies');
      yield (0, _installDependencies.default)(dir, templateModule.devDependencies || [], _installDependencies.DepType.DEV);
    }));

    if (typeof templateModule.initializeTemplate === 'function') {
      yield Promise.resolve(templateModule.initializeTemplate(dir));
    }
  });

  return function (_x, _x2) {
    return _ref.apply(this, arguments);
  };
}();

exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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