"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "ForgeMakeResult", {
  enumerable: true,
  get: function get() {
    return _sharedTypes.ForgeMakeResult;
  }
});
Object.defineProperty(exports, "ImportOptions", {
  enumerable: true,
  get: function get() {
    return _import2.ImportOptions;
  }
});
Object.defineProperty(exports, "InitOptions", {
  enumerable: true,
  get: function get() {
    return _init.InitOptions;
  }
});
Object.defineProperty(exports, "InstallOptions", {
  enumerable: true,
  get: function get() {
    return _install.InstallOptions;
  }
});
Object.defineProperty(exports, "InstallAsset", {
  enumerable: true,
  get: function get() {
    return _install.Asset;
  }
});
Object.defineProperty(exports, "LintOptions", {
  enumerable: true,
  get: function get() {
    return _lint.LintOptions;
  }
});
Object.defineProperty(exports, "MakeOptions", {
  enumerable: true,
  get: function get() {
    return _make.MakeOptions;
  }
});
Object.defineProperty(exports, "PackageOptions", {
  enumerable: true,
  get: function get() {
    return _package2.PackageOptions;
  }
});
Object.defineProperty(exports, "PublishOptions", {
  enumerable: true,
  get: function get() {
    return _publish.PublishOptions;
  }
});
Object.defineProperty(exports, "StartOptions", {
  enumerable: true,
  get: function get() {
    return _start.StartOptions;
  }
});
exports.utils = exports.api = exports.ForgeUtils = exports.ForgeAPI = void 0;

require("source-map-support/register");

require("colors");

var _sharedTypes = require("@electron-forge/shared-types");

var _import2 = _interopRequireWildcard(require("./import"));

var _init = _interopRequireWildcard(require("./init"));

var _install = _interopRequireWildcard(require("./install"));

var _lint = _interopRequireWildcard(require("./lint"));

var _make = _interopRequireWildcard(require("./make"));

var _package2 = _interopRequireWildcard(require("./package"));

var _publish = _interopRequireWildcard(require("./publish"));

var _start = _interopRequireWildcard(require("./start"));

var _forgeConfig = require("../util/forge-config");

var _yarnOrNpm = require("../util/yarn-or-npm");

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class ForgeAPI {
  /**
   * Attempt to import a given module directory to the Electron Forge standard.
   *
   * * Sets up `git` and the correct NPM dependencies
   * * Adds a template forge config to `package.json`
   */
  import(opts) {
    return (0, _import2.default)(opts);
  }
  /**
   * Initialize a new Electron Forge template project in the given directory.
   */


  init(opts) {
    return (0, _init.default)(opts);
  }
  /**
   * Install an Electron application from GitHub.
   *
   * Works on all three platforms for all major distributable types.
   */


  install(opts) {
    return (0, _install.default)(opts);
  }
  /**
   * Lint a local Electron application.
   *
   * The promise will be rejected with the stdout+stderr of the linting process
   * if linting fails or will be resolved if it succeeds.
   */


  lint(opts) {
    return (0, _lint.default)(opts);
  }
  /**
   * Make distributables for an Electron application
   */


  make(opts) {
    return (0, _make.default)(opts);
  }
  /**
   * Resolves hooks if they are a path to a file (instead of a `Function`)
   */


  package(opts) {
    return (0, _package2.default)(opts);
  }
  /**
   * Publish an Electron application into the given target service
   */


  publish(opts) {
    return (0, _publish.default)(opts);
  }
  /**
   * Start an Electron application.
   *
   * Handles things like native module rebuilding for you on the fly
   */


  start(opts) {
    return (0, _start.default)(opts);
  }

}

exports.ForgeAPI = ForgeAPI;

class ForgeUtils {
  constructor() {
    _defineProperty(this, "hasYarn", _yarnOrNpm.hasYarn);

    _defineProperty(this, "yarnOrNpmSpawn", _yarnOrNpm.yarnOrNpmSpawn);
  }

  /**
   * Helper for creating a dynamic config value that will get it's real value
   * based on the "buildIdentifier" in your forge config.
   *
   * Usage:
   * `fromBuildIdentifier({ stable: 'App', beta: 'App Beta' })`
   */
  fromBuildIdentifier(map) {
    return (0, _forgeConfig.fromBuildIdentifier)(map);
  }

}

exports.ForgeUtils = ForgeUtils;
const api = new ForgeAPI();
exports.api = api;
const utils = new ForgeUtils();
exports.utils = utils;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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