/// <reference types="node" />
import 'colors';
import { ForgeMakeResult } from '@electron-forge/shared-types';
import { ImportOptions } from './import';
import { InitOptions } from './init';
import { InstallOptions, Asset as InstallAsset } from './install';
import { LintOptions } from './lint';
import { MakeOptions } from './make';
import { PackageOptions } from './package';
import { PublishOptions } from './publish';
import { StartOptions } from './start';
export declare class ForgeAPI {
    /**
     * Attempt to import a given module directory to the Electron Forge standard.
     *
     * * Sets up `git` and the correct NPM dependencies
     * * Adds a template forge config to `package.json`
     */
    import(opts: ImportOptions): Promise<void>;
    /**
     * Initialize a new Electron Forge template project in the given directory.
     */
    init(opts: InitOptions): Promise<void>;
    /**
     * Install an Electron application from GitHub.
     *
     * Works on all three platforms for all major distributable types.
     */
    install(opts: InstallOptions): Promise<void>;
    /**
     * Lint a local Electron application.
     *
     * The promise will be rejected with the stdout+stderr of the linting process
     * if linting fails or will be resolved if it succeeds.
     */
    lint(opts: LintOptions): Promise<void>;
    /**
     * Make distributables for an Electron application
     */
    make(opts: MakeOptions): Promise<ForgeMakeResult[]>;
    /**
     * Resolves hooks if they are a path to a file (instead of a `Function`)
     */
    package(opts: PackageOptions): Promise<void>;
    /**
     * Publish an Electron application into the given target service
     */
    publish(opts: PublishOptions): Promise<void>;
    /**
     * Start an Electron application.
     *
     * Handles things like native module rebuilding for you on the fly
     */
    start(opts: StartOptions): Promise<import("child_process").ChildProcess>;
}
export declare class ForgeUtils {
    /**
     * Helper for creating a dynamic config value that will get it's real value
     * based on the "buildIdentifier" in your forge config.
     *
     * Usage:
     * `fromBuildIdentifier({ stable: 'App', beta: 'App Beta' })`
     */
    fromBuildIdentifier<T>(map: {
        [key: string]: T | undefined;
    }): {
        map: {
            [key: string]: T | undefined;
        };
        __isMagicBuildIdentifierMap: boolean;
    };
    hasYarn: () => boolean;
    yarnOrNpmSpawn: (args?: string[] | undefined, opts?: any) => Promise<Uint8Array>;
}
declare const api: ForgeAPI;
declare const utils: ForgeUtils;
export { ForgeMakeResult, ImportOptions, InitOptions, InstallAsset, InstallOptions, LintOptions, MakeOptions, PackageOptions, PublishOptions, StartOptions, api, utils, };
