"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

require("source-map-support/register");

var _lodash = _interopRequireDefault(require("lodash.merge"));

var _asyncOra = require("@electron-forge/async-ora");

var _debug = _interopRequireDefault(require("debug"));

var _fsExtra = _interopRequireDefault(require("fs-extra"));

var _path = _interopRequireDefault(require("path"));

var _initGit = _interopRequireDefault(require("./init-scripts/init-git"));

var _initNpm = require("./init-scripts/init-npm");

var _electronVersion = require("../util/electron-version");

var _forgeConfig = require("../util/forge-config");

var _messages = require("../util/messages");

var _installDependencies = _interopRequireWildcard(require("../util/install-dependencies"));

var _readPackageJson = require("../util/read-package-json");

var _upgradeForgeConfig = _interopRequireWildcard(require("../util/upgrade-forge-config"));

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

const d = (0, _debug.default)('electron-forge:import');

var _default =
/*#__PURE__*/
function () {
  var _ref = _asyncToGenerator(function* ({
    dir = process.cwd(),
    interactive = false,
    confirmImport,
    shouldContinueOnExisting,
    shouldRemoveDependency,
    shouldUpdateScript,
    outDir
  }) {
    const calculatedOutDir = outDir || 'out';
    _asyncOra.asyncOra.interactive = interactive;
    d(`Attempting to import project in: ${dir}`);

    if (!(yield _fsExtra.default.pathExists(dir)) || !(yield _fsExtra.default.pathExists(_path.default.resolve(dir, 'package.json')))) {
      throw new Error(`We couldn't find a project in: ${dir}`);
    } // eslint-disable-next-line max-len


    if (typeof confirmImport === 'function') {
      if (!(yield confirmImport())) {
        process.exit(0);
      }
    }

    yield (0, _initGit.default)(dir);
    const importDeps = [].concat(_initNpm.deps);
    let importDevDeps = [].concat(_initNpm.devDeps);
    let importExactDevDeps = [].concat(_initNpm.exactDevDeps);
    let packageJSON = yield (0, _readPackageJson.readRawPackageJson)(dir);

    if (packageJSON.config && packageJSON.config.forge) {
      if (packageJSON.config.forge.makers) {
        (0, _messages.warn)(interactive, 'It looks like this project is already configured for Electron Forge'.green);

        if (typeof shouldContinueOnExisting === 'function') {
          if (!(yield shouldContinueOnExisting())) {
            process.exit(0);
          }
        }
      } else if (typeof packageJSON.config.forge === 'string') {
        (0, _messages.warn)(interactive, "We can't tell if the Electron Forge config is compatible because it's in an external JavaScript file, not trying to convert it and continuing anyway".yellow);
      } else {
        d('Upgrading an Electron Forge < 6 project');
        packageJSON.config.forge = (0, _upgradeForgeConfig.default)(packageJSON.config.forge);
        importDevDeps = (0, _upgradeForgeConfig.updateUpgradedForgeDevDeps)(packageJSON, importDevDeps);
      }
    }

    packageJSON.dependencies = packageJSON.dependencies || {};
    packageJSON.devDependencies = packageJSON.devDependencies || {};

    var _updateElectronDepend = (0, _electronVersion.updateElectronDependency)(packageJSON, importDevDeps, importExactDevDeps);

    var _updateElectronDepend2 = _slicedToArray(_updateElectronDepend, 2);

    importDevDeps = _updateElectronDepend2[0];
    importExactDevDeps = _updateElectronDepend2[1];
    const keys = Object.keys(packageJSON.dependencies).concat(Object.keys(packageJSON.devDependencies));
    const buildToolPackages = {
      '@electron/get': 'already uses this module as a transitive dependency',
      'electron-builder': 'provides mostly equivalent functionality',
      'electron-download': 'already uses this module as a transitive dependency',
      'electron-forge': 'replaced with @electron-forge/cli',
      'electron-installer-debian': 'already uses this module as a transitive dependency',
      'electron-installer-dmg': 'already uses this module as a transitive dependency',
      'electron-installer-flatpak': 'already uses this module as a transitive dependency',
      'electron-installer-redhat': 'already uses this module as a transitive dependency',
      'electron-osx-sign': 'already uses this module as a transitive dependency',
      'electron-packager': 'already uses this module as a transitive dependency',
      'electron-winstaller': 'already uses this module as a transitive dependency'
    };
    var _iteratorNormalCompletion = true;
    var _didIteratorError = false;
    var _iteratorError = undefined;

    try {
      for (var _iterator = keys[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
        const key = _step.value;

        if (buildToolPackages[key]) {
          const explanation = buildToolPackages[key]; // eslint-disable-next-line max-len

          let remove = true;

          if (typeof shouldRemoveDependency === 'function') {
            remove = yield shouldRemoveDependency(key, explanation);
          }

          if (remove) {
            delete packageJSON.dependencies[key];
            delete packageJSON.devDependencies[key];
          }
        }
      }
    } catch (err) {
      _didIteratorError = true;
      _iteratorError = err;
    } finally {
      try {
        if (!_iteratorNormalCompletion && _iterator.return != null) {
          _iterator.return();
        }
      } finally {
        if (_didIteratorError) {
          throw _iteratorError;
        }
      }
    }

    packageJSON.scripts = packageJSON.scripts || {};
    d('reading current scripts object:', packageJSON.scripts);

    const updatePackageScript =
    /*#__PURE__*/
    function () {
      var _ref2 = _asyncToGenerator(function* (scriptName, newValue) {
        if (packageJSON.scripts[scriptName] !== newValue) {
          // eslint-disable-next-line max-len
          let update = true;

          if (typeof shouldUpdateScript === 'function') {
            update = yield shouldUpdateScript(scriptName, newValue);
          }

          if (update) {
            packageJSON.scripts[scriptName] = newValue;
          }
        }
      });

      return function updatePackageScript(_x2, _x3) {
        return _ref2.apply(this, arguments);
      };
    }();

    yield updatePackageScript('start', 'electron-forge start');
    yield updatePackageScript('package', 'electron-forge package');
    yield updatePackageScript('make', 'electron-forge make');
    d('forgified scripts object:', packageJSON.scripts);

    const writeChanges =
    /*#__PURE__*/
    function () {
      var _ref3 = _asyncToGenerator(function* () {
        yield (0, _asyncOra.asyncOra)('Writing modified package.json file',
        /*#__PURE__*/
        _asyncToGenerator(function* () {
          yield _fsExtra.default.writeJson(_path.default.resolve(dir, 'package.json'), packageJSON, {
            spaces: 2
          });
        }));
      });

      return function writeChanges() {
        return _ref3.apply(this, arguments);
      };
    }();

    yield writeChanges();
    yield (0, _asyncOra.asyncOra)('Installing dependencies',
    /*#__PURE__*/
    _asyncToGenerator(function* () {
      d('deleting old dependencies forcefully');
      yield _fsExtra.default.remove(_path.default.resolve(dir, 'node_modules/.bin/electron'));
      yield _fsExtra.default.remove(_path.default.resolve(dir, 'node_modules/.bin/electron.cmd'));
      d('installing dependencies');
      yield (0, _installDependencies.default)(dir, importDeps);
      d('installing devDependencies');
      yield (0, _installDependencies.default)(dir, importDevDeps, _installDependencies.DepType.DEV);
      d('installing exactDevDependencies');
      yield (0, _installDependencies.default)(dir, importExactDevDeps, _installDependencies.DepType.DEV, _installDependencies.DepVersionRestriction.EXACT);
    }));
    packageJSON = yield (0, _readPackageJson.readRawPackageJson)(dir);

    if (!packageJSON.version) {
      (0, _messages.warn)(interactive, 'Please set the "version" in your application\'s package.json'.yellow);
    }

    packageJSON.config = packageJSON.config || {};
    const templatePackageJSON = yield (0, _readPackageJson.readRawPackageJson)(_path.default.resolve(__dirname, '../../tmpl'));

    if (packageJSON.config.forge) {
      if (typeof packageJSON.config.forge !== 'string') {
        packageJSON.config.forge = (0, _lodash.default)(templatePackageJSON.config.forge, packageJSON.config.forge);
      }
    } else {
      packageJSON.config.forge = templatePackageJSON.config.forge;
    }

    if (typeof packageJSON.config.forge !== 'string') {
      (0, _forgeConfig.setInitialForgeConfig)(packageJSON);
    }

    yield writeChanges();
    yield (0, _asyncOra.asyncOra)('Fixing .gitignore',
    /*#__PURE__*/
    _asyncToGenerator(function* () {
      if (yield _fsExtra.default.pathExists(_path.default.resolve(dir, '.gitignore'))) {
        const gitignore = yield _fsExtra.default.readFile(_path.default.resolve(dir, '.gitignore'));

        if (!gitignore.includes(calculatedOutDir)) {
          yield _fsExtra.default.writeFile(_path.default.resolve(dir, '.gitignore'), `${gitignore}\n${calculatedOutDir}/`);
        }
      }
    }));
    (0, _messages.info)(interactive, `

We have ATTEMPTED to convert your app to be in a format that electron-forge understands.

Thanks for using ${'"electron-forge"'.green}!!!`);
  });

  return function (_x) {
    return _ref.apply(this, arguments);
  };
}();

exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9hcGkvaW1wb3J0LnRzIl0sIm5hbWVzIjpbImQiLCJkaXIiLCJwcm9jZXNzIiwiY3dkIiwiaW50ZXJhY3RpdmUiLCJjb25maXJtSW1wb3J0Iiwic2hvdWxkQ29udGludWVPbkV4aXN0aW5nIiwic2hvdWxkUmVtb3ZlRGVwZW5kZW5jeSIsInNob3VsZFVwZGF0ZVNjcmlwdCIsIm91dERpciIsImNhbGN1bGF0ZWRPdXREaXIiLCJhc3luY09yYSIsImZzIiwicGF0aEV4aXN0cyIsInBhdGgiLCJyZXNvbHZlIiwiRXJyb3IiLCJleGl0IiwiaW1wb3J0RGVwcyIsImNvbmNhdCIsImRlcHMiLCJpbXBvcnREZXZEZXBzIiwiZGV2RGVwcyIsImltcG9ydEV4YWN0RGV2RGVwcyIsImV4YWN0RGV2RGVwcyIsInBhY2thZ2VKU09OIiwiY29uZmlnIiwiZm9yZ2UiLCJtYWtlcnMiLCJncmVlbiIsInllbGxvdyIsImRlcGVuZGVuY2llcyIsImRldkRlcGVuZGVuY2llcyIsImtleXMiLCJPYmplY3QiLCJidWlsZFRvb2xQYWNrYWdlcyIsImtleSIsImV4cGxhbmF0aW9uIiwicmVtb3ZlIiwic2NyaXB0cyIsInVwZGF0ZVBhY2thZ2VTY3JpcHQiLCJzY3JpcHROYW1lIiwibmV3VmFsdWUiLCJ1cGRhdGUiLCJ3cml0ZUNoYW5nZXMiLCJ3cml0ZUpzb24iLCJzcGFjZXMiLCJEZXBUeXBlIiwiREVWIiwiRGVwVmVyc2lvblJlc3RyaWN0aW9uIiwiRVhBQ1QiLCJ2ZXJzaW9uIiwidGVtcGxhdGVQYWNrYWdlSlNPTiIsIl9fZGlybmFtZSIsImdpdGlnbm9yZSIsInJlYWRGaWxlIiwiaW5jbHVkZXMiLCJ3cml0ZUZpbGUiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7OztBQUFBOztBQUNBOztBQUNBOztBQUNBOztBQUNBOztBQUVBOztBQUNBOztBQUVBOztBQUNBOztBQUNBOztBQUNBOztBQUNBOztBQUNBOzs7Ozs7Ozs7Ozs7Ozs7Ozs7QUFFQSxNQUFNQSxDQUFDLEdBQUcsb0JBQU0sdUJBQU4sQ0FBVjs7Ozs7K0JBbUNlLFdBQU87QUFDcEJDLElBQUFBLEdBQUcsR0FBR0MsT0FBTyxDQUFDQyxHQUFSLEVBRGM7QUFFcEJDLElBQUFBLFdBQVcsR0FBRyxLQUZNO0FBR3BCQyxJQUFBQSxhQUhvQjtBQUlwQkMsSUFBQUEsd0JBSm9CO0FBS3BCQyxJQUFBQSxzQkFMb0I7QUFNcEJDLElBQUFBLGtCQU5vQjtBQU9wQkMsSUFBQUE7QUFQb0IsR0FBUCxFQVFNO0FBQ25CLFVBQU1DLGdCQUFnQixHQUFHRCxNQUFNLElBQUksS0FBbkM7QUFDQUUsdUJBQVNQLFdBQVQsR0FBdUJBLFdBQXZCO0FBRUFKLElBQUFBLENBQUMsQ0FBRSxvQ0FBbUNDLEdBQUksRUFBekMsQ0FBRDs7QUFDQSxRQUFJLFFBQU9XLGlCQUFHQyxVQUFILENBQWNaLEdBQWQsQ0FBUCxLQUE2QixRQUFPVyxpQkFBR0MsVUFBSCxDQUFjQyxjQUFLQyxPQUFMLENBQWFkLEdBQWIsRUFBa0IsY0FBbEIsQ0FBZCxDQUFQLENBQWpDLEVBQTBGO0FBQ3hGLFlBQU0sSUFBSWUsS0FBSixDQUFXLGtDQUFpQ2YsR0FBSSxFQUFoRCxDQUFOO0FBQ0QsS0FQa0IsQ0FTbkI7OztBQUNBLFFBQUksT0FBT0ksYUFBUCxLQUF5QixVQUE3QixFQUF5QztBQUN2QyxVQUFJLFFBQU9BLGFBQWEsRUFBcEIsQ0FBSixFQUE0QjtBQUMxQkgsUUFBQUEsT0FBTyxDQUFDZSxJQUFSLENBQWEsQ0FBYjtBQUNEO0FBQ0Y7O0FBRUQsVUFBTSxzQkFBUWhCLEdBQVIsQ0FBTjtBQUVBLFVBQU1pQixVQUFVLEdBQUksRUFBRCxDQUFpQkMsTUFBakIsQ0FBd0JDLGFBQXhCLENBQW5CO0FBQ0EsUUFBSUMsYUFBYSxHQUFJLEVBQUQsQ0FBaUJGLE1BQWpCLENBQXdCRyxnQkFBeEIsQ0FBcEI7QUFDQSxRQUFJQyxrQkFBa0IsR0FBSSxFQUFELENBQWlCSixNQUFqQixDQUF3QksscUJBQXhCLENBQXpCO0FBRUEsUUFBSUMsV0FBVyxTQUFTLHlDQUFtQnhCLEdBQW5CLENBQXhCOztBQUNBLFFBQUl3QixXQUFXLENBQUNDLE1BQVosSUFBc0JELFdBQVcsQ0FBQ0MsTUFBWixDQUFtQkMsS0FBN0MsRUFBb0Q7QUFDbEQsVUFBSUYsV0FBVyxDQUFDQyxNQUFaLENBQW1CQyxLQUFuQixDQUF5QkMsTUFBN0IsRUFBcUM7QUFDbkMsNEJBQUt4QixXQUFMLEVBQWtCLHNFQUFzRXlCLEtBQXhGOztBQUNBLFlBQUksT0FBT3ZCLHdCQUFQLEtBQW9DLFVBQXhDLEVBQW9EO0FBQ2xELGNBQUksUUFBT0Esd0JBQXdCLEVBQS9CLENBQUosRUFBdUM7QUFDckNKLFlBQUFBLE9BQU8sQ0FBQ2UsSUFBUixDQUFhLENBQWI7QUFDRDtBQUNGO0FBQ0YsT0FQRCxNQU9PLElBQUksT0FBT1EsV0FBVyxDQUFDQyxNQUFaLENBQW1CQyxLQUExQixLQUFvQyxRQUF4QyxFQUFrRDtBQUN2RCw0QkFBS3ZCLFdBQUwsRUFBa0IsdUpBQXVKMEIsTUFBeks7QUFDRCxPQUZNLE1BRUE7QUFDTDlCLFFBQUFBLENBQUMsQ0FBQyx5Q0FBRCxDQUFEO0FBQ0F5QixRQUFBQSxXQUFXLENBQUNDLE1BQVosQ0FBbUJDLEtBQW5CLEdBQTJCLGlDQUFtQkYsV0FBVyxDQUFDQyxNQUFaLENBQW1CQyxLQUF0QyxDQUEzQjtBQUNBTixRQUFBQSxhQUFhLEdBQUcsb0RBQTJCSSxXQUEzQixFQUF3Q0osYUFBeEMsQ0FBaEI7QUFDRDtBQUNGOztBQUVESSxJQUFBQSxXQUFXLENBQUNNLFlBQVosR0FBMkJOLFdBQVcsQ0FBQ00sWUFBWixJQUE0QixFQUF2RDtBQUNBTixJQUFBQSxXQUFXLENBQUNPLGVBQVosR0FBOEJQLFdBQVcsQ0FBQ08sZUFBWixJQUErQixFQUE3RDs7QUF6Q21CLGdDQTJDbUIsK0NBQ3BDUCxXQURvQyxFQUVwQ0osYUFGb0MsRUFHcENFLGtCQUhvQyxDQTNDbkI7O0FBQUE7O0FBMkNsQkYsSUFBQUEsYUEzQ2tCO0FBMkNIRSxJQUFBQSxrQkEzQ0c7QUFpRG5CLFVBQU1VLElBQUksR0FBR0MsTUFBTSxDQUFDRCxJQUFQLENBQVlSLFdBQVcsQ0FBQ00sWUFBeEIsRUFDVlosTUFEVSxDQUNIZSxNQUFNLENBQUNELElBQVAsQ0FBWVIsV0FBVyxDQUFDTyxlQUF4QixDQURHLENBQWI7QUFFQSxVQUFNRyxpQkFFTCxHQUFHO0FBQ0YsdUJBQWlCLHFEQURmO0FBRUYsMEJBQW9CLDBDQUZsQjtBQUdGLDJCQUFxQixxREFIbkI7QUFJRix3QkFBa0IsbUNBSmhCO0FBS0YsbUNBQTZCLHFEQUwzQjtBQU1GLGdDQUEwQixxREFOeEI7QUFPRixvQ0FBOEIscURBUDVCO0FBUUYsbUNBQTZCLHFEQVIzQjtBQVNGLDJCQUFxQixxREFUbkI7QUFVRiwyQkFBcUIscURBVm5CO0FBV0YsNkJBQXVCO0FBWHJCLEtBRko7QUFuRG1CO0FBQUE7QUFBQTs7QUFBQTtBQW1FbkIsMkJBQWtCRixJQUFsQiw4SEFBd0I7QUFBQSxjQUFiRyxHQUFhOztBQUN0QixZQUFJRCxpQkFBaUIsQ0FBQ0MsR0FBRCxDQUFyQixFQUE0QjtBQUMxQixnQkFBTUMsV0FBVyxHQUFHRixpQkFBaUIsQ0FBQ0MsR0FBRCxDQUFyQyxDQUQwQixDQUUxQjs7QUFDQSxjQUFJRSxNQUFNLEdBQUcsSUFBYjs7QUFDQSxjQUFJLE9BQU8vQixzQkFBUCxLQUFrQyxVQUF0QyxFQUFrRDtBQUNoRCtCLFlBQUFBLE1BQU0sU0FBUy9CLHNCQUFzQixDQUFDNkIsR0FBRCxFQUFNQyxXQUFOLENBQXJDO0FBQ0Q7O0FBRUQsY0FBSUMsTUFBSixFQUFZO0FBQ1YsbUJBQU9iLFdBQVcsQ0FBQ00sWUFBWixDQUF5QkssR0FBekIsQ0FBUDtBQUNBLG1CQUFPWCxXQUFXLENBQUNPLGVBQVosQ0FBNEJJLEdBQTVCLENBQVA7QUFDRDtBQUNGO0FBQ0Y7QUFqRmtCO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7O0FBbUZuQlgsSUFBQUEsV0FBVyxDQUFDYyxPQUFaLEdBQXNCZCxXQUFXLENBQUNjLE9BQVosSUFBdUIsRUFBN0M7QUFDQXZDLElBQUFBLENBQUMsQ0FBQyxpQ0FBRCxFQUFvQ3lCLFdBQVcsQ0FBQ2MsT0FBaEQsQ0FBRDs7QUFFQSxVQUFNQyxtQkFBbUI7QUFBQTtBQUFBO0FBQUEsb0NBQUcsV0FBT0MsVUFBUCxFQUEyQkMsUUFBM0IsRUFBZ0Q7QUFDMUUsWUFBSWpCLFdBQVcsQ0FBQ2MsT0FBWixDQUFvQkUsVUFBcEIsTUFBb0NDLFFBQXhDLEVBQWtEO0FBQ2hEO0FBQ0EsY0FBSUMsTUFBTSxHQUFHLElBQWI7O0FBQ0EsY0FBSSxPQUFPbkMsa0JBQVAsS0FBOEIsVUFBbEMsRUFBOEM7QUFDNUNtQyxZQUFBQSxNQUFNLFNBQVNuQyxrQkFBa0IsQ0FBQ2lDLFVBQUQsRUFBYUMsUUFBYixDQUFqQztBQUNEOztBQUNELGNBQUlDLE1BQUosRUFBWTtBQUNWbEIsWUFBQUEsV0FBVyxDQUFDYyxPQUFaLENBQW9CRSxVQUFwQixJQUFrQ0MsUUFBbEM7QUFDRDtBQUNGO0FBQ0YsT0FYd0I7O0FBQUEsc0JBQW5CRixtQkFBbUI7QUFBQTtBQUFBO0FBQUEsT0FBekI7O0FBYUEsVUFBTUEsbUJBQW1CLENBQUMsT0FBRCxFQUFVLHNCQUFWLENBQXpCO0FBQ0EsVUFBTUEsbUJBQW1CLENBQUMsU0FBRCxFQUFZLHdCQUFaLENBQXpCO0FBQ0EsVUFBTUEsbUJBQW1CLENBQUMsTUFBRCxFQUFTLHFCQUFULENBQXpCO0FBRUF4QyxJQUFBQSxDQUFDLENBQUMsMkJBQUQsRUFBOEJ5QixXQUFXLENBQUNjLE9BQTFDLENBQUQ7O0FBRUEsVUFBTUssWUFBWTtBQUFBO0FBQUE7QUFBQSxvQ0FBRyxhQUFZO0FBQy9CLGNBQU0sd0JBQVMsb0NBQVQ7QUFBQTtBQUFBLDBCQUErQyxhQUFZO0FBQy9ELGdCQUFNaEMsaUJBQUdpQyxTQUFILENBQWEvQixjQUFLQyxPQUFMLENBQWFkLEdBQWIsRUFBa0IsY0FBbEIsQ0FBYixFQUFnRHdCLFdBQWhELEVBQTZEO0FBQUVxQixZQUFBQSxNQUFNLEVBQUU7QUFBVixXQUE3RCxDQUFOO0FBQ0QsU0FGSyxFQUFOO0FBR0QsT0FKaUI7O0FBQUEsc0JBQVpGLFlBQVk7QUFBQTtBQUFBO0FBQUEsT0FBbEI7O0FBTUEsVUFBTUEsWUFBWSxFQUFsQjtBQUVBLFVBQU0sd0JBQVMseUJBQVQ7QUFBQTtBQUFBLHNCQUFvQyxhQUFZO0FBQ3BENUMsTUFBQUEsQ0FBQyxDQUFDLHNDQUFELENBQUQ7QUFDQSxZQUFNWSxpQkFBRzBCLE1BQUgsQ0FBVXhCLGNBQUtDLE9BQUwsQ0FBYWQsR0FBYixFQUFrQiw0QkFBbEIsQ0FBVixDQUFOO0FBQ0EsWUFBTVcsaUJBQUcwQixNQUFILENBQVV4QixjQUFLQyxPQUFMLENBQWFkLEdBQWIsRUFBa0IsZ0NBQWxCLENBQVYsQ0FBTjtBQUVBRCxNQUFBQSxDQUFDLENBQUMseUJBQUQsQ0FBRDtBQUNBLFlBQU0sa0NBQWVDLEdBQWYsRUFBb0JpQixVQUFwQixDQUFOO0FBRUFsQixNQUFBQSxDQUFDLENBQUMsNEJBQUQsQ0FBRDtBQUNBLFlBQU0sa0NBQWVDLEdBQWYsRUFBb0JvQixhQUFwQixFQUFtQzBCLDZCQUFRQyxHQUEzQyxDQUFOO0FBRUFoRCxNQUFBQSxDQUFDLENBQUMsaUNBQUQsQ0FBRDtBQUNBLFlBQU0sa0NBQWVDLEdBQWYsRUFBb0JzQixrQkFBcEIsRUFBd0N3Qiw2QkFBUUMsR0FBaEQsRUFBcURDLDJDQUFzQkMsS0FBM0UsQ0FBTjtBQUNELEtBYkssRUFBTjtBQWVBekIsSUFBQUEsV0FBVyxTQUFTLHlDQUFtQnhCLEdBQW5CLENBQXBCOztBQUVBLFFBQUksQ0FBQ3dCLFdBQVcsQ0FBQzBCLE9BQWpCLEVBQTBCO0FBQ3hCLDBCQUFLL0MsV0FBTCxFQUFrQiwrREFBK0QwQixNQUFqRjtBQUNEOztBQUVETCxJQUFBQSxXQUFXLENBQUNDLE1BQVosR0FBcUJELFdBQVcsQ0FBQ0MsTUFBWixJQUFzQixFQUEzQztBQUNBLFVBQU0wQixtQkFBbUIsU0FBUyx5Q0FBbUJ0QyxjQUFLQyxPQUFMLENBQWFzQyxTQUFiLEVBQXdCLFlBQXhCLENBQW5CLENBQWxDOztBQUNBLFFBQUk1QixXQUFXLENBQUNDLE1BQVosQ0FBbUJDLEtBQXZCLEVBQThCO0FBQzVCLFVBQUksT0FBT0YsV0FBVyxDQUFDQyxNQUFaLENBQW1CQyxLQUExQixLQUFvQyxRQUF4QyxFQUFrRDtBQUNoREYsUUFBQUEsV0FBVyxDQUFDQyxNQUFaLENBQW1CQyxLQUFuQixHQUEyQixxQkFBT3lCLG1CQUFtQixDQUFDMUIsTUFBcEIsQ0FBMkJDLEtBQWxDLEVBQXlDRixXQUFXLENBQUNDLE1BQVosQ0FBbUJDLEtBQTVELENBQTNCO0FBQ0Q7QUFDRixLQUpELE1BSU87QUFDTEYsTUFBQUEsV0FBVyxDQUFDQyxNQUFaLENBQW1CQyxLQUFuQixHQUEyQnlCLG1CQUFtQixDQUFDMUIsTUFBcEIsQ0FBMkJDLEtBQXREO0FBQ0Q7O0FBRUQsUUFBSSxPQUFPRixXQUFXLENBQUNDLE1BQVosQ0FBbUJDLEtBQTFCLEtBQW9DLFFBQXhDLEVBQWtEO0FBQ2hELDhDQUFzQkYsV0FBdEI7QUFDRDs7QUFFRCxVQUFNbUIsWUFBWSxFQUFsQjtBQUVBLFVBQU0sd0JBQVMsbUJBQVQ7QUFBQTtBQUFBLHNCQUE4QixhQUFZO0FBQzlDLGdCQUFVaEMsaUJBQUdDLFVBQUgsQ0FBY0MsY0FBS0MsT0FBTCxDQUFhZCxHQUFiLEVBQWtCLFlBQWxCLENBQWQsQ0FBVixFQUEwRDtBQUN4RCxjQUFNcUQsU0FBUyxTQUFTMUMsaUJBQUcyQyxRQUFILENBQVl6QyxjQUFLQyxPQUFMLENBQWFkLEdBQWIsRUFBa0IsWUFBbEIsQ0FBWixDQUF4Qjs7QUFDQSxZQUFJLENBQUNxRCxTQUFTLENBQUNFLFFBQVYsQ0FBbUI5QyxnQkFBbkIsQ0FBTCxFQUEyQztBQUN6QyxnQkFBTUUsaUJBQUc2QyxTQUFILENBQWEzQyxjQUFLQyxPQUFMLENBQWFkLEdBQWIsRUFBa0IsWUFBbEIsQ0FBYixFQUErQyxHQUFFcUQsU0FBVSxLQUFJNUMsZ0JBQWlCLEdBQWhGLENBQU47QUFDRDtBQUNGO0FBQ0YsS0FQSyxFQUFOO0FBU0Esd0JBQUtOLFdBQUwsRUFBbUI7Ozs7bUJBSUYsbUJBQW1CeUIsS0FBTSxLQUoxQztBQUtELEciLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgX21lcmdlIGZyb20gJ2xvZGFzaC5tZXJnZSc7XG5pbXBvcnQgeyBhc3luY09yYSB9IGZyb20gJ0BlbGVjdHJvbi1mb3JnZS9hc3luYy1vcmEnO1xuaW1wb3J0IGRlYnVnIGZyb20gJ2RlYnVnJztcbmltcG9ydCBmcyBmcm9tICdmcy1leHRyYSc7XG5pbXBvcnQgcGF0aCBmcm9tICdwYXRoJztcblxuaW1wb3J0IGluaXRHaXQgZnJvbSAnLi9pbml0LXNjcmlwdHMvaW5pdC1naXQnO1xuaW1wb3J0IHsgZGVwcywgZGV2RGVwcywgZXhhY3REZXZEZXBzIH0gZnJvbSAnLi9pbml0LXNjcmlwdHMvaW5pdC1ucG0nO1xuXG5pbXBvcnQgeyB1cGRhdGVFbGVjdHJvbkRlcGVuZGVuY3kgfSBmcm9tICcuLi91dGlsL2VsZWN0cm9uLXZlcnNpb24nO1xuaW1wb3J0IHsgc2V0SW5pdGlhbEZvcmdlQ29uZmlnIH0gZnJvbSAnLi4vdXRpbC9mb3JnZS1jb25maWcnO1xuaW1wb3J0IHsgaW5mbywgd2FybiB9IGZyb20gJy4uL3V0aWwvbWVzc2FnZXMnO1xuaW1wb3J0IGluc3RhbGxEZXBMaXN0LCB7IERlcFR5cGUsIERlcFZlcnNpb25SZXN0cmljdGlvbiB9IGZyb20gJy4uL3V0aWwvaW5zdGFsbC1kZXBlbmRlbmNpZXMnO1xuaW1wb3J0IHsgcmVhZFJhd1BhY2thZ2VKc29uIH0gZnJvbSAnLi4vdXRpbC9yZWFkLXBhY2thZ2UtanNvbic7XG5pbXBvcnQgdXBncmFkZUZvcmdlQ29uZmlnLCB7IHVwZGF0ZVVwZ3JhZGVkRm9yZ2VEZXZEZXBzIH0gZnJvbSAnLi4vdXRpbC91cGdyYWRlLWZvcmdlLWNvbmZpZyc7XG5cbmNvbnN0IGQgPSBkZWJ1ZygnZWxlY3Ryb24tZm9yZ2U6aW1wb3J0Jyk7XG5cbmV4cG9ydCBpbnRlcmZhY2UgSW1wb3J0T3B0aW9ucyB7XG4gIC8qKlxuICAgKiBUaGUgcGF0aCB0byB0aGUgYXBwIHRvIGJlIGltcG9ydGVkXG4gICAqL1xuICBkaXI/OiBzdHJpbmc7XG4gIC8qKlxuICAgKiBXaGV0aGVyIHRvIHVzZSBzZW5zaWJsZSBkZWZhdWx0cyBvciBwcm9tcHQgdGhlIHVzZXIgdmlzdWFsbHlcbiAgICovXG4gIGludGVyYWN0aXZlPzogYm9vbGVhbjtcbiAgLyoqXG4gICAqIEFuIGFzeW5jIGZ1bmN0aW9uIHRoYXQgcmV0dXJucyB0cnVlIG9yIGZhbHNlIGluIG9yZGVyIHRvIGNvbmZpcm0gdGhlIHN0YXJ0XG4gICAqIG9mIGltcG9ydGluZ1xuICAgKi9cbiAgY29uZmlybUltcG9ydD86ICgpID0+IFByb21pc2U8Ym9vbGVhbj47XG4gIC8qKlxuICAgKiBBbiBhc3luYyBmdW5jdGlvbiB0aGF0IHJldHVybnMgd2hldGhlciB0aGUgaW1wb3J0IHNob3VsZCBjb250aW51ZSBpZiBpdFxuICAgKiBsb29rcyBsaWtlIGEgZm9yZ2UgcHJvamVjdCBhbHJlYWR5XG4gICAqL1xuICBzaG91bGRDb250aW51ZU9uRXhpc3Rpbmc/OiAoKSA9PiBQcm9taXNlPGJvb2xlYW4+O1xuICAvKipcbiAgICogQW4gYXN5bmMgZnVuY3Rpb24gdGhhdCByZXR1cm5zIHdoZXRoZXIgdGhlIGdpdmVuIGRlcGVuZGVuY3kgc2hvdWxkIGJlIHJlbW92ZWRcbiAgICovXG4gIHNob3VsZFJlbW92ZURlcGVuZGVuY3k/OiAoZGVwZW5kZW5jeTogc3RyaW5nLCBleHBsYW5hdGlvbjogc3RyaW5nKSA9PiBQcm9taXNlPGJvb2xlYW4+O1xuICAvKipcbiAgICogQW4gYXN5bmMgZnVuY3Rpb24gdGhhdCByZXR1cm5zIHdoZXRoZXIgdGhlIGdpdmVuIHNjcmlwdCBzaG91bGQgYmUgb3ZlcnJpZGRlbiB3aXRoIGEgZm9yZ2Ugb25lXG4gICAqL1xuICBzaG91bGRVcGRhdGVTY3JpcHQ/OiAoc2NyaXB0TmFtZTogc3RyaW5nLCBuZXdWYWx1ZTogc3RyaW5nKSA9PiBQcm9taXNlPGJvb2xlYW4+O1xuICAvKipcbiAgICogVGhlIHBhdGggdG8gdGhlIGRpcmVjdG9yeSBjb250YWluaW5nIGdlbmVyYXRlZCBkaXN0cmlidXRhYmxlc1xuICAgKi9cbiAgb3V0RGlyPzogc3RyaW5nO1xufVxuXG5leHBvcnQgZGVmYXVsdCBhc3luYyAoe1xuICBkaXIgPSBwcm9jZXNzLmN3ZCgpLFxuICBpbnRlcmFjdGl2ZSA9IGZhbHNlLFxuICBjb25maXJtSW1wb3J0LFxuICBzaG91bGRDb250aW51ZU9uRXhpc3RpbmcsXG4gIHNob3VsZFJlbW92ZURlcGVuZGVuY3ksXG4gIHNob3VsZFVwZGF0ZVNjcmlwdCxcbiAgb3V0RGlyLFxufTogSW1wb3J0T3B0aW9ucykgPT4ge1xuICBjb25zdCBjYWxjdWxhdGVkT3V0RGlyID0gb3V0RGlyIHx8ICdvdXQnO1xuICBhc3luY09yYS5pbnRlcmFjdGl2ZSA9IGludGVyYWN0aXZlO1xuXG4gIGQoYEF0dGVtcHRpbmcgdG8gaW1wb3J0IHByb2plY3QgaW46ICR7ZGlyfWApO1xuICBpZiAoIWF3YWl0IGZzLnBhdGhFeGlzdHMoZGlyKSB8fCAhYXdhaXQgZnMucGF0aEV4aXN0cyhwYXRoLnJlc29sdmUoZGlyLCAncGFja2FnZS5qc29uJykpKSB7XG4gICAgdGhyb3cgbmV3IEVycm9yKGBXZSBjb3VsZG4ndCBmaW5kIGEgcHJvamVjdCBpbjogJHtkaXJ9YCk7XG4gIH1cblxuICAvLyBlc2xpbnQtZGlzYWJsZS1uZXh0LWxpbmUgbWF4LWxlblxuICBpZiAodHlwZW9mIGNvbmZpcm1JbXBvcnQgPT09ICdmdW5jdGlvbicpIHtcbiAgICBpZiAoIWF3YWl0IGNvbmZpcm1JbXBvcnQoKSkge1xuICAgICAgcHJvY2Vzcy5leGl0KDApO1xuICAgIH1cbiAgfVxuXG4gIGF3YWl0IGluaXRHaXQoZGlyKTtcblxuICBjb25zdCBpbXBvcnREZXBzID0gKFtdIGFzIHN0cmluZ1tdKS5jb25jYXQoZGVwcyk7XG4gIGxldCBpbXBvcnREZXZEZXBzID0gKFtdIGFzIHN0cmluZ1tdKS5jb25jYXQoZGV2RGVwcyk7XG4gIGxldCBpbXBvcnRFeGFjdERldkRlcHMgPSAoW10gYXMgc3RyaW5nW10pLmNvbmNhdChleGFjdERldkRlcHMpO1xuXG4gIGxldCBwYWNrYWdlSlNPTiA9IGF3YWl0IHJlYWRSYXdQYWNrYWdlSnNvbihkaXIpO1xuICBpZiAocGFja2FnZUpTT04uY29uZmlnICYmIHBhY2thZ2VKU09OLmNvbmZpZy5mb3JnZSkge1xuICAgIGlmIChwYWNrYWdlSlNPTi5jb25maWcuZm9yZ2UubWFrZXJzKSB7XG4gICAgICB3YXJuKGludGVyYWN0aXZlLCAnSXQgbG9va3MgbGlrZSB0aGlzIHByb2plY3QgaXMgYWxyZWFkeSBjb25maWd1cmVkIGZvciBFbGVjdHJvbiBGb3JnZScuZ3JlZW4pO1xuICAgICAgaWYgKHR5cGVvZiBzaG91bGRDb250aW51ZU9uRXhpc3RpbmcgPT09ICdmdW5jdGlvbicpIHtcbiAgICAgICAgaWYgKCFhd2FpdCBzaG91bGRDb250aW51ZU9uRXhpc3RpbmcoKSkge1xuICAgICAgICAgIHByb2Nlc3MuZXhpdCgwKTtcbiAgICAgICAgfVxuICAgICAgfVxuICAgIH0gZWxzZSBpZiAodHlwZW9mIHBhY2thZ2VKU09OLmNvbmZpZy5mb3JnZSA9PT0gJ3N0cmluZycpIHtcbiAgICAgIHdhcm4oaW50ZXJhY3RpdmUsIFwiV2UgY2FuJ3QgdGVsbCBpZiB0aGUgRWxlY3Ryb24gRm9yZ2UgY29uZmlnIGlzIGNvbXBhdGlibGUgYmVjYXVzZSBpdCdzIGluIGFuIGV4dGVybmFsIEphdmFTY3JpcHQgZmlsZSwgbm90IHRyeWluZyB0byBjb252ZXJ0IGl0IGFuZCBjb250aW51aW5nIGFueXdheVwiLnllbGxvdyk7XG4gICAgfSBlbHNlIHtcbiAgICAgIGQoJ1VwZ3JhZGluZyBhbiBFbGVjdHJvbiBGb3JnZSA8IDYgcHJvamVjdCcpO1xuICAgICAgcGFja2FnZUpTT04uY29uZmlnLmZvcmdlID0gdXBncmFkZUZvcmdlQ29uZmlnKHBhY2thZ2VKU09OLmNvbmZpZy5mb3JnZSk7XG4gICAgICBpbXBvcnREZXZEZXBzID0gdXBkYXRlVXBncmFkZWRGb3JnZURldkRlcHMocGFja2FnZUpTT04sIGltcG9ydERldkRlcHMpO1xuICAgIH1cbiAgfVxuXG4gIHBhY2thZ2VKU09OLmRlcGVuZGVuY2llcyA9IHBhY2thZ2VKU09OLmRlcGVuZGVuY2llcyB8fCB7fTtcbiAgcGFja2FnZUpTT04uZGV2RGVwZW5kZW5jaWVzID0gcGFja2FnZUpTT04uZGV2RGVwZW5kZW5jaWVzIHx8IHt9O1xuXG4gIFtpbXBvcnREZXZEZXBzLCBpbXBvcnRFeGFjdERldkRlcHNdID0gdXBkYXRlRWxlY3Ryb25EZXBlbmRlbmN5KFxuICAgIHBhY2thZ2VKU09OLFxuICAgIGltcG9ydERldkRlcHMsXG4gICAgaW1wb3J0RXhhY3REZXZEZXBzLFxuICApO1xuXG4gIGNvbnN0IGtleXMgPSBPYmplY3Qua2V5cyhwYWNrYWdlSlNPTi5kZXBlbmRlbmNpZXMpXG4gICAgLmNvbmNhdChPYmplY3Qua2V5cyhwYWNrYWdlSlNPTi5kZXZEZXBlbmRlbmNpZXMpKTtcbiAgY29uc3QgYnVpbGRUb29sUGFja2FnZXM6IHtcbiAgICBba2V5OiBzdHJpbmddOiBzdHJpbmcgfCB1bmRlZmluZWQ7XG4gIH0gPSB7XG4gICAgJ0BlbGVjdHJvbi9nZXQnOiAnYWxyZWFkeSB1c2VzIHRoaXMgbW9kdWxlIGFzIGEgdHJhbnNpdGl2ZSBkZXBlbmRlbmN5JyxcbiAgICAnZWxlY3Ryb24tYnVpbGRlcic6ICdwcm92aWRlcyBtb3N0bHkgZXF1aXZhbGVudCBmdW5jdGlvbmFsaXR5JyxcbiAgICAnZWxlY3Ryb24tZG93bmxvYWQnOiAnYWxyZWFkeSB1c2VzIHRoaXMgbW9kdWxlIGFzIGEgdHJhbnNpdGl2ZSBkZXBlbmRlbmN5JyxcbiAgICAnZWxlY3Ryb24tZm9yZ2UnOiAncmVwbGFjZWQgd2l0aCBAZWxlY3Ryb24tZm9yZ2UvY2xpJyxcbiAgICAnZWxlY3Ryb24taW5zdGFsbGVyLWRlYmlhbic6ICdhbHJlYWR5IHVzZXMgdGhpcyBtb2R1bGUgYXMgYSB0cmFuc2l0aXZlIGRlcGVuZGVuY3knLFxuICAgICdlbGVjdHJvbi1pbnN0YWxsZXItZG1nJzogJ2FscmVhZHkgdXNlcyB0aGlzIG1vZHVsZSBhcyBhIHRyYW5zaXRpdmUgZGVwZW5kZW5jeScsXG4gICAgJ2VsZWN0cm9uLWluc3RhbGxlci1mbGF0cGFrJzogJ2FscmVhZHkgdXNlcyB0aGlzIG1vZHVsZSBhcyBhIHRyYW5zaXRpdmUgZGVwZW5kZW5jeScsXG4gICAgJ2VsZWN0cm9uLWluc3RhbGxlci1yZWRoYXQnOiAnYWxyZWFkeSB1c2VzIHRoaXMgbW9kdWxlIGFzIGEgdHJhbnNpdGl2ZSBkZXBlbmRlbmN5JyxcbiAgICAnZWxlY3Ryb24tb3N4LXNpZ24nOiAnYWxyZWFkeSB1c2VzIHRoaXMgbW9kdWxlIGFzIGEgdHJhbnNpdGl2ZSBkZXBlbmRlbmN5JyxcbiAgICAnZWxlY3Ryb24tcGFja2FnZXInOiAnYWxyZWFkeSB1c2VzIHRoaXMgbW9kdWxlIGFzIGEgdHJhbnNpdGl2ZSBkZXBlbmRlbmN5JyxcbiAgICAnZWxlY3Ryb24td2luc3RhbGxlcic6ICdhbHJlYWR5IHVzZXMgdGhpcyBtb2R1bGUgYXMgYSB0cmFuc2l0aXZlIGRlcGVuZGVuY3knLFxuICB9O1xuXG4gIGZvciAoY29uc3Qga2V5IG9mIGtleXMpIHtcbiAgICBpZiAoYnVpbGRUb29sUGFja2FnZXNba2V5XSkge1xuICAgICAgY29uc3QgZXhwbGFuYXRpb24gPSBidWlsZFRvb2xQYWNrYWdlc1trZXldITtcbiAgICAgIC8vIGVzbGludC1kaXNhYmxlLW5leHQtbGluZSBtYXgtbGVuXG4gICAgICBsZXQgcmVtb3ZlID0gdHJ1ZTtcbiAgICAgIGlmICh0eXBlb2Ygc2hvdWxkUmVtb3ZlRGVwZW5kZW5jeSA9PT0gJ2Z1bmN0aW9uJykge1xuICAgICAgICByZW1vdmUgPSBhd2FpdCBzaG91bGRSZW1vdmVEZXBlbmRlbmN5KGtleSwgZXhwbGFuYXRpb24pO1xuICAgICAgfVxuXG4gICAgICBpZiAocmVtb3ZlKSB7XG4gICAgICAgIGRlbGV0ZSBwYWNrYWdlSlNPTi5kZXBlbmRlbmNpZXNba2V5XTtcbiAgICAgICAgZGVsZXRlIHBhY2thZ2VKU09OLmRldkRlcGVuZGVuY2llc1trZXldO1xuICAgICAgfVxuICAgIH1cbiAgfVxuXG4gIHBhY2thZ2VKU09OLnNjcmlwdHMgPSBwYWNrYWdlSlNPTi5zY3JpcHRzIHx8IHt9O1xuICBkKCdyZWFkaW5nIGN1cnJlbnQgc2NyaXB0cyBvYmplY3Q6JywgcGFja2FnZUpTT04uc2NyaXB0cyk7XG5cbiAgY29uc3QgdXBkYXRlUGFja2FnZVNjcmlwdCA9IGFzeW5jIChzY3JpcHROYW1lOiBzdHJpbmcsIG5ld1ZhbHVlOiBzdHJpbmcpID0+IHtcbiAgICBpZiAocGFja2FnZUpTT04uc2NyaXB0c1tzY3JpcHROYW1lXSAhPT0gbmV3VmFsdWUpIHtcbiAgICAgIC8vIGVzbGludC1kaXNhYmxlLW5leHQtbGluZSBtYXgtbGVuXG4gICAgICBsZXQgdXBkYXRlID0gdHJ1ZTtcbiAgICAgIGlmICh0eXBlb2Ygc2hvdWxkVXBkYXRlU2NyaXB0ID09PSAnZnVuY3Rpb24nKSB7XG4gICAgICAgIHVwZGF0ZSA9IGF3YWl0IHNob3VsZFVwZGF0ZVNjcmlwdChzY3JpcHROYW1lLCBuZXdWYWx1ZSk7XG4gICAgICB9XG4gICAgICBpZiAodXBkYXRlKSB7XG4gICAgICAgIHBhY2thZ2VKU09OLnNjcmlwdHNbc2NyaXB0TmFtZV0gPSBuZXdWYWx1ZTtcbiAgICAgIH1cbiAgICB9XG4gIH07XG5cbiAgYXdhaXQgdXBkYXRlUGFja2FnZVNjcmlwdCgnc3RhcnQnLCAnZWxlY3Ryb24tZm9yZ2Ugc3RhcnQnKTtcbiAgYXdhaXQgdXBkYXRlUGFja2FnZVNjcmlwdCgncGFja2FnZScsICdlbGVjdHJvbi1mb3JnZSBwYWNrYWdlJyk7XG4gIGF3YWl0IHVwZGF0ZVBhY2thZ2VTY3JpcHQoJ21ha2UnLCAnZWxlY3Ryb24tZm9yZ2UgbWFrZScpO1xuXG4gIGQoJ2ZvcmdpZmllZCBzY3JpcHRzIG9iamVjdDonLCBwYWNrYWdlSlNPTi5zY3JpcHRzKTtcblxuICBjb25zdCB3cml0ZUNoYW5nZXMgPSBhc3luYyAoKSA9PiB7XG4gICAgYXdhaXQgYXN5bmNPcmEoJ1dyaXRpbmcgbW9kaWZpZWQgcGFja2FnZS5qc29uIGZpbGUnLCBhc3luYyAoKSA9PiB7XG4gICAgICBhd2FpdCBmcy53cml0ZUpzb24ocGF0aC5yZXNvbHZlKGRpciwgJ3BhY2thZ2UuanNvbicpLCBwYWNrYWdlSlNPTiwgeyBzcGFjZXM6IDIgfSk7XG4gICAgfSk7XG4gIH07XG5cbiAgYXdhaXQgd3JpdGVDaGFuZ2VzKCk7XG5cbiAgYXdhaXQgYXN5bmNPcmEoJ0luc3RhbGxpbmcgZGVwZW5kZW5jaWVzJywgYXN5bmMgKCkgPT4ge1xuICAgIGQoJ2RlbGV0aW5nIG9sZCBkZXBlbmRlbmNpZXMgZm9yY2VmdWxseScpO1xuICAgIGF3YWl0IGZzLnJlbW92ZShwYXRoLnJlc29sdmUoZGlyLCAnbm9kZV9tb2R1bGVzLy5iaW4vZWxlY3Ryb24nKSk7XG4gICAgYXdhaXQgZnMucmVtb3ZlKHBhdGgucmVzb2x2ZShkaXIsICdub2RlX21vZHVsZXMvLmJpbi9lbGVjdHJvbi5jbWQnKSk7XG5cbiAgICBkKCdpbnN0YWxsaW5nIGRlcGVuZGVuY2llcycpO1xuICAgIGF3YWl0IGluc3RhbGxEZXBMaXN0KGRpciwgaW1wb3J0RGVwcyk7XG5cbiAgICBkKCdpbnN0YWxsaW5nIGRldkRlcGVuZGVuY2llcycpO1xuICAgIGF3YWl0IGluc3RhbGxEZXBMaXN0KGRpciwgaW1wb3J0RGV2RGVwcywgRGVwVHlwZS5ERVYpO1xuXG4gICAgZCgnaW5zdGFsbGluZyBleGFjdERldkRlcGVuZGVuY2llcycpO1xuICAgIGF3YWl0IGluc3RhbGxEZXBMaXN0KGRpciwgaW1wb3J0RXhhY3REZXZEZXBzLCBEZXBUeXBlLkRFViwgRGVwVmVyc2lvblJlc3RyaWN0aW9uLkVYQUNUKTtcbiAgfSk7XG5cbiAgcGFja2FnZUpTT04gPSBhd2FpdCByZWFkUmF3UGFja2FnZUpzb24oZGlyKTtcblxuICBpZiAoIXBhY2thZ2VKU09OLnZlcnNpb24pIHtcbiAgICB3YXJuKGludGVyYWN0aXZlLCAnUGxlYXNlIHNldCB0aGUgXCJ2ZXJzaW9uXCIgaW4geW91ciBhcHBsaWNhdGlvblxcJ3MgcGFja2FnZS5qc29uJy55ZWxsb3cpO1xuICB9XG5cbiAgcGFja2FnZUpTT04uY29uZmlnID0gcGFja2FnZUpTT04uY29uZmlnIHx8IHt9O1xuICBjb25zdCB0ZW1wbGF0ZVBhY2thZ2VKU09OID0gYXdhaXQgcmVhZFJhd1BhY2thZ2VKc29uKHBhdGgucmVzb2x2ZShfX2Rpcm5hbWUsICcuLi8uLi90bXBsJykpO1xuICBpZiAocGFja2FnZUpTT04uY29uZmlnLmZvcmdlKSB7XG4gICAgaWYgKHR5cGVvZiBwYWNrYWdlSlNPTi5jb25maWcuZm9yZ2UgIT09ICdzdHJpbmcnKSB7XG4gICAgICBwYWNrYWdlSlNPTi5jb25maWcuZm9yZ2UgPSBfbWVyZ2UodGVtcGxhdGVQYWNrYWdlSlNPTi5jb25maWcuZm9yZ2UsIHBhY2thZ2VKU09OLmNvbmZpZy5mb3JnZSk7XG4gICAgfVxuICB9IGVsc2Uge1xuICAgIHBhY2thZ2VKU09OLmNvbmZpZy5mb3JnZSA9IHRlbXBsYXRlUGFja2FnZUpTT04uY29uZmlnLmZvcmdlO1xuICB9XG5cbiAgaWYgKHR5cGVvZiBwYWNrYWdlSlNPTi5jb25maWcuZm9yZ2UgIT09ICdzdHJpbmcnKSB7XG4gICAgc2V0SW5pdGlhbEZvcmdlQ29uZmlnKHBhY2thZ2VKU09OKTtcbiAgfVxuXG4gIGF3YWl0IHdyaXRlQ2hhbmdlcygpO1xuXG4gIGF3YWl0IGFzeW5jT3JhKCdGaXhpbmcgLmdpdGlnbm9yZScsIGFzeW5jICgpID0+IHtcbiAgICBpZiAoYXdhaXQgZnMucGF0aEV4aXN0cyhwYXRoLnJlc29sdmUoZGlyLCAnLmdpdGlnbm9yZScpKSkge1xuICAgICAgY29uc3QgZ2l0aWdub3JlID0gYXdhaXQgZnMucmVhZEZpbGUocGF0aC5yZXNvbHZlKGRpciwgJy5naXRpZ25vcmUnKSk7XG4gICAgICBpZiAoIWdpdGlnbm9yZS5pbmNsdWRlcyhjYWxjdWxhdGVkT3V0RGlyKSkge1xuICAgICAgICBhd2FpdCBmcy53cml0ZUZpbGUocGF0aC5yZXNvbHZlKGRpciwgJy5naXRpZ25vcmUnKSwgYCR7Z2l0aWdub3JlfVxcbiR7Y2FsY3VsYXRlZE91dERpcn0vYCk7XG4gICAgICB9XG4gICAgfVxuICB9KTtcblxuICBpbmZvKGludGVyYWN0aXZlLCBgXG5cbldlIGhhdmUgQVRURU1QVEVEIHRvIGNvbnZlcnQgeW91ciBhcHAgdG8gYmUgaW4gYSBmb3JtYXQgdGhhdCBlbGVjdHJvbi1mb3JnZSB1bmRlcnN0YW5kcy5cblxuVGhhbmtzIGZvciB1c2luZyAkeydcImVsZWN0cm9uLWZvcmdlXCInLmdyZWVufSEhIWApO1xufTtcbiJdfQ==