"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;

require("source-map-support/register");

var _fsExtra = _interopRequireDefault(require("fs-extra"));

var _path = _interopRequireDefault(require("path"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _default(dir, cwd, checkExisting = true) {
  let finalDir = dir;

  if (cwd) {
    if (_path.default.isAbsolute(cwd) && (!checkExisting || _fsExtra.default.existsSync(cwd))) {
      finalDir = cwd;
    } else {
      const resolved = _path.default.resolve(finalDir, cwd);

      if (!checkExisting || _fsExtra.default.existsSync(resolved)) {
        finalDir = resolved;
      }
    }
  }

  return finalDir;
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy91dGlsL3dvcmtpbmctZGlyLnRzIl0sIm5hbWVzIjpbImRpciIsImN3ZCIsImNoZWNrRXhpc3RpbmciLCJmaW5hbERpciIsInBhdGgiLCJpc0Fic29sdXRlIiwiZnMiLCJleGlzdHNTeW5jIiwicmVzb2x2ZWQiLCJyZXNvbHZlIl0sIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7QUFBQTs7QUFDQTs7OztBQUVlLGtCQUFVQSxHQUFWLEVBQXVCQyxHQUF2QixFQUFvQ0MsYUFBc0IsR0FBRyxJQUE3RCxFQUEyRTtBQUN4RixNQUFJQyxRQUFRLEdBQUdILEdBQWY7O0FBQ0EsTUFBSUMsR0FBSixFQUFTO0FBQ1AsUUFBSUcsY0FBS0MsVUFBTCxDQUFnQkosR0FBaEIsTUFBeUIsQ0FBQ0MsYUFBRCxJQUFrQkksaUJBQUdDLFVBQUgsQ0FBY04sR0FBZCxDQUEzQyxDQUFKLEVBQW9FO0FBQ2xFRSxNQUFBQSxRQUFRLEdBQUdGLEdBQVg7QUFDRCxLQUZELE1BRU87QUFDTCxZQUFNTyxRQUFRLEdBQUdKLGNBQUtLLE9BQUwsQ0FBYU4sUUFBYixFQUF1QkYsR0FBdkIsQ0FBakI7O0FBQ0EsVUFBSSxDQUFDQyxhQUFELElBQWtCSSxpQkFBR0MsVUFBSCxDQUFjQyxRQUFkLENBQXRCLEVBQStDO0FBQzdDTCxRQUFBQSxRQUFRLEdBQUdLLFFBQVg7QUFDRDtBQUNGO0FBQ0Y7O0FBRUQsU0FBT0wsUUFBUDtBQUNEIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IGZzIGZyb20gJ2ZzLWV4dHJhJztcbmltcG9ydCBwYXRoIGZyb20gJ3BhdGgnO1xuXG5leHBvcnQgZGVmYXVsdCBmdW5jdGlvbiAoZGlyOiBzdHJpbmcsIGN3ZDogc3RyaW5nLCBjaGVja0V4aXN0aW5nOiBib29sZWFuID0gdHJ1ZSk6IHN0cmluZyB7XG4gIGxldCBmaW5hbERpciA9IGRpcjtcbiAgaWYgKGN3ZCkge1xuICAgIGlmIChwYXRoLmlzQWJzb2x1dGUoY3dkKSAmJiAoIWNoZWNrRXhpc3RpbmcgfHwgZnMuZXhpc3RzU3luYyhjd2QpKSkge1xuICAgICAgZmluYWxEaXIgPSBjd2Q7XG4gICAgfSBlbHNlIHtcbiAgICAgIGNvbnN0IHJlc29sdmVkID0gcGF0aC5yZXNvbHZlKGZpbmFsRGlyLCBjd2QpO1xuICAgICAgaWYgKCFjaGVja0V4aXN0aW5nIHx8IGZzLmV4aXN0c1N5bmMocmVzb2x2ZWQpKSB7XG4gICAgICAgIGZpbmFsRGlyID0gcmVzb2x2ZWQ7XG4gICAgICB9XG4gICAgfVxuICB9XG5cbiAgcmV0dXJuIGZpbmFsRGlyO1xufVxuIl19