"use strict";

require("source-map-support/register");

var _colors = _interopRequireDefault(require("colors"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

process.on('unhandledRejection', (reason, promise) => {
  console.error('\nAn unhandled rejection has occurred inside Forge:'.red);
  console.error(_colors.default.red(reason));
  console.error('\nElectron Forge was terminated. Location:'.red);
  console.error(_colors.default.red(JSON.stringify(promise)));
  process.exit(1);
});
process.on('uncaughtException', err => {
  if (err && err.message && err.stack) {
    console.error('\nAn unhandled exception has occurred inside Forge:'.red);
    console.error(_colors.default.red(err.message));
    console.error(_colors.default.red(err.stack));
  } else {
    console.error('\nElectron Forge was terminated:'.red);
    console.error(_colors.default.red(typeof err === 'string' ? err : JSON.stringify(err)));
  }

  process.exit(1);
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy91dGlsL3Rlcm1pbmF0ZS50cyJdLCJuYW1lcyI6WyJwcm9jZXNzIiwib24iLCJyZWFzb24iLCJwcm9taXNlIiwiY29uc29sZSIsImVycm9yIiwicmVkIiwiY29sb3JzIiwiSlNPTiIsInN0cmluZ2lmeSIsImV4aXQiLCJlcnIiLCJtZXNzYWdlIiwic3RhY2siXSwibWFwcGluZ3MiOiI7Ozs7QUFBQTs7OztBQUVBQSxPQUFPLENBQUNDLEVBQVIsQ0FBVyxvQkFBWCxFQUFpQyxDQUFDQyxNQUFELEVBQWNDLE9BQWQsS0FBd0M7QUFDdkVDLEVBQUFBLE9BQU8sQ0FBQ0MsS0FBUixDQUFjLHNEQUFzREMsR0FBcEU7QUFDQUYsRUFBQUEsT0FBTyxDQUFDQyxLQUFSLENBQWNFLGdCQUFPRCxHQUFQLENBQVdKLE1BQVgsQ0FBZDtBQUNBRSxFQUFBQSxPQUFPLENBQUNDLEtBQVIsQ0FBYyw2Q0FBNkNDLEdBQTNEO0FBQ0FGLEVBQUFBLE9BQU8sQ0FBQ0MsS0FBUixDQUFjRSxnQkFBT0QsR0FBUCxDQUFXRSxJQUFJLENBQUNDLFNBQUwsQ0FBZU4sT0FBZixDQUFYLENBQWQ7QUFDQUgsRUFBQUEsT0FBTyxDQUFDVSxJQUFSLENBQWEsQ0FBYjtBQUNELENBTkQ7QUFRQVYsT0FBTyxDQUFDQyxFQUFSLENBQVcsbUJBQVgsRUFBaUNVLEdBQUQsSUFBUztBQUN2QyxNQUFJQSxHQUFHLElBQUlBLEdBQUcsQ0FBQ0MsT0FBWCxJQUFzQkQsR0FBRyxDQUFDRSxLQUE5QixFQUFxQztBQUNuQ1QsSUFBQUEsT0FBTyxDQUFDQyxLQUFSLENBQWMsc0RBQXNEQyxHQUFwRTtBQUNBRixJQUFBQSxPQUFPLENBQUNDLEtBQVIsQ0FBY0UsZ0JBQU9ELEdBQVAsQ0FBV0ssR0FBRyxDQUFDQyxPQUFmLENBQWQ7QUFDQVIsSUFBQUEsT0FBTyxDQUFDQyxLQUFSLENBQWNFLGdCQUFPRCxHQUFQLENBQVdLLEdBQUcsQ0FBQ0UsS0FBZixDQUFkO0FBQ0QsR0FKRCxNQUlPO0FBQ0xULElBQUFBLE9BQU8sQ0FBQ0MsS0FBUixDQUFjLG1DQUFtQ0MsR0FBakQ7QUFDQUYsSUFBQUEsT0FBTyxDQUFDQyxLQUFSLENBQWNFLGdCQUFPRCxHQUFQLENBQVcsT0FBT0ssR0FBUCxLQUFlLFFBQWYsR0FBMEJBLEdBQTFCLEdBQWdDSCxJQUFJLENBQUNDLFNBQUwsQ0FBZUUsR0FBZixDQUEzQyxDQUFkO0FBQ0Q7O0FBQ0RYLEVBQUFBLE9BQU8sQ0FBQ1UsSUFBUixDQUFhLENBQWI7QUFDRCxDQVZEIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IGNvbG9ycyBmcm9tICdjb2xvcnMnO1xuXG5wcm9jZXNzLm9uKCd1bmhhbmRsZWRSZWplY3Rpb24nLCAocmVhc29uOiBhbnksIHByb21pc2U6IFByb21pc2U8YW55PikgPT4ge1xuICBjb25zb2xlLmVycm9yKCdcXG5BbiB1bmhhbmRsZWQgcmVqZWN0aW9uIGhhcyBvY2N1cnJlZCBpbnNpZGUgRm9yZ2U6Jy5yZWQpO1xuICBjb25zb2xlLmVycm9yKGNvbG9ycy5yZWQocmVhc29uKSk7XG4gIGNvbnNvbGUuZXJyb3IoJ1xcbkVsZWN0cm9uIEZvcmdlIHdhcyB0ZXJtaW5hdGVkLiBMb2NhdGlvbjonLnJlZCk7XG4gIGNvbnNvbGUuZXJyb3IoY29sb3JzLnJlZChKU09OLnN0cmluZ2lmeShwcm9taXNlKSkpO1xuICBwcm9jZXNzLmV4aXQoMSk7XG59KTtcblxucHJvY2Vzcy5vbigndW5jYXVnaHRFeGNlcHRpb24nLCAoZXJyKSA9PiB7XG4gIGlmIChlcnIgJiYgZXJyLm1lc3NhZ2UgJiYgZXJyLnN0YWNrKSB7XG4gICAgY29uc29sZS5lcnJvcignXFxuQW4gdW5oYW5kbGVkIGV4Y2VwdGlvbiBoYXMgb2NjdXJyZWQgaW5zaWRlIEZvcmdlOicucmVkKTtcbiAgICBjb25zb2xlLmVycm9yKGNvbG9ycy5yZWQoZXJyLm1lc3NhZ2UpKTtcbiAgICBjb25zb2xlLmVycm9yKGNvbG9ycy5yZWQoZXJyLnN0YWNrKSk7XG4gIH0gZWxzZSB7XG4gICAgY29uc29sZS5lcnJvcignXFxuRWxlY3Ryb24gRm9yZ2Ugd2FzIHRlcm1pbmF0ZWQ6Jy5yZWQpO1xuICAgIGNvbnNvbGUuZXJyb3IoY29sb3JzLnJlZCh0eXBlb2YgZXJyID09PSAnc3RyaW5nJyA/IGVyciA6IEpTT04uc3RyaW5naWZ5KGVycikpKTtcbiAgfVxuICBwcm9jZXNzLmV4aXQoMSk7XG59KTtcbiJdfQ==