"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validPackageManagerVersion = validPackageManagerVersion;
exports.default = _default;

require("source-map-support/register");

var _child_process = require("child_process");

var _debug = _interopRequireDefault(require("debug"));

var _fsExtra = _interopRequireDefault(require("fs-extra"));

var _os = _interopRequireDefault(require("os"));

var _path = _interopRequireDefault(require("path"));

var _semver = _interopRequireDefault(require("semver"));

var _core = require("@electron-forge/core");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

const d = (0, _debug.default)('electron-forge:check-system');

function checkGitExists() {
  return _checkGitExists.apply(this, arguments);
}

function _checkGitExists() {
  _checkGitExists = _asyncToGenerator(function* () {
    return new Promise(resolve => {
      (0, _child_process.exec)('git --version', err => resolve(!err));
    });
  });
  return _checkGitExists.apply(this, arguments);
}

function checkNodeVersion() {
  return _checkNodeVersion.apply(this, arguments);
}

function _checkNodeVersion() {
  _checkNodeVersion = _asyncToGenerator(function* () {
    return Promise.resolve(_semver.default.gt(process.versions.node, '6.0.0'));
  });
  return _checkNodeVersion.apply(this, arguments);
}

const NPM_WHITELISTED_VERSIONS = {
  all: '^3.0.0 || ^4.0.0 || ~5.1.0 || ~5.2.0 || >= 5.4.2',
  darwin: '>= 5.4.0',
  linux: '>= 5.4.0'
};
const YARN_WHITELISTED_VERSIONS = {
  all: '0.23.3 || 0.24.6 || >= 1.0.0',
  darwin: '0.27.5',
  linux: '0.27.5'
};

function validPackageManagerVersion(packageManager, version, whitelistedVersions, ora) {
  try {
    return _semver.default.satisfies(version, whitelistedVersions);
  } catch (e) {
    ora.warn(`Could not check ${packageManager} version "${version}", assuming incompatible`);
    d(`Exception while checking version: ${e}`);
    return false;
  }
}

function warnIfPackageManagerIsntAKnownGoodVersion(packageManager, version, whitelistedVersions, ora) {
  const osVersions = whitelistedVersions[process.platform];
  const versions = osVersions ? `${whitelistedVersions.all} || ${osVersions}` : whitelistedVersions.all;
  const versionString = version.toString();

  if (!validPackageManagerVersion(packageManager, versionString, versions, ora)) {
    ora.warn(`You are using ${packageManager}, but not a known good version.
The known versions that work with Electron Forge are: ${versions}`);
  }
}

function checkPackageManagerVersion(_x) {
  return _checkPackageManagerVersion.apply(this, arguments);
}
/**
 * Some people know their system is OK and don't appreciate the 800ms lag in
 * start up that these checks (in particular the package manager check) costs.
 *
 * Simply creating this flag file in your home directory will skip these checks
 * and shave ~800ms off your forge start time.
 *
 * This is specifically not documented or everyone would make it.
 */


function _checkPackageManagerVersion() {
  _checkPackageManagerVersion = _asyncToGenerator(function* (ora) {
    return _core.utils.yarnOrNpmSpawn(['--version']).then(version => {
      const versionString = version.toString();

      if (_core.utils.hasYarn()) {
        warnIfPackageManagerIsntAKnownGoodVersion('Yarn', versionString, YARN_WHITELISTED_VERSIONS, ora);
      } else {
        warnIfPackageManagerIsntAKnownGoodVersion('NPM', versionString, NPM_WHITELISTED_VERSIONS, ora);
      }

      return true;
    });
  });
  return _checkPackageManagerVersion.apply(this, arguments);
}

const SKIP_SYSTEM_CHECK = _path.default.resolve(_os.default.homedir(), '.skip-forge-system-check');

function _default(_x2) {
  return _ref.apply(this, arguments);
}

function _ref() {
  _ref = _asyncToGenerator(function* (ora) {
    if (!(yield _fsExtra.default.pathExists(SKIP_SYSTEM_CHECK))) {
      d('checking system, create ~/.skip-forge-system-check to stop doing this');
      return (yield Promise.all([checkGitExists(), checkNodeVersion(), checkPackageManagerVersion(ora)])).every(check => check);
    }

    d('skipping system check');
    return true;
  });
  return _ref.apply(this, arguments);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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