#!/usr/bin/env node
"use strict";

require("source-map-support/register");

require("colors");

var _asyncOra = require("@electron-forge/async-ora");

var _commander = _interopRequireDefault(require("commander"));

require("./util/terminate");

var _checkSystem = _interopRequireDefault(require("./util/check-system"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

const originalSC = _commander.default.executeSubCommand.bind(_commander.default);

_commander.default.executeSubCommand = (argv, args, unknown) => {
  let indexOfDoubleDash = process.argv.indexOf('--');
  indexOfDoubleDash = indexOfDoubleDash < 0 ? process.argv.length + 1 : indexOfDoubleDash;
  const passThroughArgs = args.filter(arg => process.argv.indexOf(arg) > indexOfDoubleDash);
  const normalArgs = args.filter(arg => process.argv.indexOf(arg) <= indexOfDoubleDash);
  let newArgs = args;
  let newUnknown = unknown;

  if (passThroughArgs.length > 0) {
    newArgs = normalArgs.concat(unknown).concat('--').concat(passThroughArgs);
    newUnknown = [];
  }

  return originalSC(argv, newArgs, newUnknown);
};

_commander.default.version(require('../package.json').version).option('--verbose', 'Enables verbose mode').command('init', 'Initialize a new Electron application').command('import', 'Attempts to navigate you through the process of importing an existing project to "electron-forge"').command('lint', 'Lints the current Electron application').command('package', 'Package the current Electron application').command('make', 'Generate distributables for the current Electron application').command('start', 'Start the current Electron application').command('publish', 'Publish the current Electron application to GitHub').command('install', 'Install an Electron application from GitHub');

_asyncToGenerator(function* () {
  let goodSystem;
  yield (0, _asyncOra.asyncOra)('Checking your system',
  /*#__PURE__*/
  function () {
    var _ref2 = _asyncToGenerator(function* (ora) {
      goodSystem = yield (0, _checkSystem.default)(ora);
    });

    return function (_x) {
      return _ref2.apply(this, arguments);
    };
  }());

  if (!goodSystem) {
    console.error(`It looks like you are missing some dependencies you need to get Electron running.
Make sure you have git installed and Node.js version 6.0.0+`.red);
    process.exit(1);
  }

  _commander.default.parse(process.argv);
})();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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