"use strict";

require("source-map-support/register");

var _core = require("@electron-forge/core");

var _fsExtra = _interopRequireDefault(require("fs-extra"));

var _commander = _interopRequireDefault(require("commander"));

var _path = _interopRequireDefault(require("path"));

require("./util/terminate");

var _workingDir = _interopRequireDefault(require("./util/working-dir"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

_asyncToGenerator(function* () {
  let commandArgs = process.argv;
  let appArgs;
  const doubleDashIndex = process.argv.indexOf('--');

  if (doubleDashIndex !== -1) {
    commandArgs = process.argv.slice(0, doubleDashIndex);
    appArgs = process.argv.slice(doubleDashIndex + 1);
  }

  let dir = process.cwd();

  _commander.default.version((yield _fsExtra.default.readJson(_path.default.resolve(__dirname, '../package.json'))).version).arguments('[cwd]').option('-p, --app-path <path>', 'Override the path to the Electron app to launch (defaults to \'.\')').option('-l, --enable-logging', 'Enable advanced logging.  This will log internal Electron things').option('-n, --run-as-node', 'Run the Electron app as a Node.JS script').option('--vscode', 'Used to enable arg transformation for debugging Electron through VSCode.  Do not use yourself.').option('-i, --inspect-electron', 'Triggers inspect mode on Electron to allow debugging the main process.  Electron >1.7 only').action(cwd => {
    dir = (0, _workingDir.default)(dir, cwd);
  }).parse(commandArgs);

  _commander.default.on('--help', () => {
    console.log('  Any arguments found after "--" will be passed to the Electron app, e.g.');
    console.log('');
    console.log('    $ electron-forge /path/to/project -l -- -d -f foo.txt');
    console.log('');
    console.log('  will pass the arguments "-d -f foo.txt" to the Electron app');
  });

  const opts = {
    dir,
    interactive: true,
    enableLogging: !!_commander.default.enableLogging,
    runAsNode: !!_commander.default.runAsNode,
    inspect: !!_commander.default.inspectElectron
  };

  if (_commander.default.vscode && appArgs) {
    // Args are in the format ~arg~ so we need to strip the "~"
    appArgs = appArgs.map(arg => arg.substr(1, arg.length - 2)).filter(arg => arg.length > 0);
  }

  if (_commander.default.appPath) opts.appPath = _commander.default.appPath;
  if (appArgs) opts.args = appArgs;
  const spawned = yield _core.api.start(opts);
  yield new Promise(resolve => {
    const listenForExit = child => {
      let onExit;
      let onRestart;

      const removeListeners = () => {
        child.removeListener('exit', onExit);
        child.removeListener('restarted', onRestart);
      };

      onExit = code => {
        removeListeners();
        if (spawned.restarted) return;

        if (code !== 0) {
          process.exit(code);
        }

        resolve();
      };

      onRestart = newChild => {
        removeListeners();
        listenForExit(newChild);
      };

      child.on('exit', onExit);
      child.on('restarted', onRestart);
    };

    listenForExit(spawned);
  });
})();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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