"use strict";

require("source-map-support/register");

var _core = require("@electron-forge/core");

var _fsExtra = _interopRequireDefault(require("fs-extra"));

var _commander = _interopRequireDefault(require("commander"));

var _path = _interopRequireDefault(require("path"));

require("./util/terminate");

var _workingDir = _interopRequireDefault(require("./util/working-dir"));

var _electronForgeMake = require("./electron-forge-make");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

_asyncToGenerator(function* () {
  let dir = process.cwd();

  _commander.default.version((yield _fsExtra.default.readJson(_path.default.resolve(__dirname, '../package.json'))).version).arguments('[cwd]').option('--target [target[,target...]]', 'The comma-separated deployment targets, defaults to "github"').option('--dry-run', 'Triggers a publish dry run which saves state and doesn\'t upload anything').option('--from-dry-run', 'Attempts to publish artifacts from the last saved dry run').allowUnknownOption(true).action(cwd => {
    dir = (0, _workingDir.default)(dir, cwd);
  }).parse(process.argv);

  const publishOpts = {
    dir,
    interactive: true,
    dryRun: _commander.default.dryRun,
    dryRunResume: _commander.default.fromDryRun
  };
  if (_commander.default.target) publishOpts.publishTargets = _commander.default.target.split(',');
  publishOpts.makeOptions = yield (0, _electronForgeMake.getMakeOptions)();
  yield _core.api.publish(publishOpts);
})();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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