"use strict";

require("source-map-support/register");

var _core = require("@electron-forge/core");

var _fsExtra = _interopRequireDefault(require("fs-extra"));

var _commander = _interopRequireDefault(require("commander"));

var _path = _interopRequireDefault(require("path"));

require("./util/terminate");

var _workingDir = _interopRequireDefault(require("./util/working-dir"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

_asyncToGenerator(function* () {
  let dir = process.cwd();

  _commander.default.version((yield _fsExtra.default.readJson(_path.default.resolve(__dirname, '../package.json'))).version).arguments('[cwd]').option('-a, --arch [arch]', 'Target architecture').option('-p, --platform [platform]', 'Target build platform').action(cwd => {
    dir = (0, _workingDir.default)(dir, cwd);
  }).parse(process.argv);

  const packageOpts = {
    dir,
    interactive: true
  };
  if (_commander.default.arch) packageOpts.arch = _commander.default.arch;
  if (_commander.default.platform) packageOpts.platform = _commander.default.platform;
  yield _core.api.package(packageOpts);
})();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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