"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMakeOptions = getMakeOptions;

require("source-map-support/register");

var _core = require("@electron-forge/core");

var _fsExtra = _interopRequireDefault(require("fs-extra"));

var _commander = _interopRequireDefault(require("commander"));

var _path = _interopRequireDefault(require("path"));

require("./util/terminate");

var _workingDir = _interopRequireDefault(require("./util/working-dir"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

// eslint-disable-next-line import/prefer-default-export
function getMakeOptions() {
  return _getMakeOptions.apply(this, arguments);
} // eslint-disable-next-line no-underscore-dangle


function _getMakeOptions() {
  _getMakeOptions = _asyncToGenerator(function* () {
    let dir = process.cwd();

    _commander.default.version((yield _fsExtra.default.readJson(_path.default.resolve(__dirname, '../package.json'))).version).arguments('[cwd]').option('--skip-package', 'Assume the app is already packaged').option('-a, --arch [arch]', 'Target architecture').option('-p, --platform [platform]', 'Target build platform').option('--targets [targets]', 'Override your make targets for this run').allowUnknownOption(true).action(cwd => {
      dir = (0, _workingDir.default)(dir, cwd);
    }).parse(process.argv);

    const makeOpts = {
      dir,
      interactive: true,
      skipPackage: _commander.default.skipPackage
    };
    if (_commander.default.targets) makeOpts.overrideTargets = _commander.default.targets.split(',');
    if (_commander.default.arch) makeOpts.arch = _commander.default.arch;
    if (_commander.default.platform) makeOpts.platform = _commander.default.platform;
    return makeOpts;
  });
  return _getMakeOptions.apply(this, arguments);
}

if (process.mainModule === module || global.__LINKED_FORGE__) {
  _asyncToGenerator(function* () {
    const makeOpts = yield getMakeOptions();
    yield _core.api.make(makeOpts);
  })();
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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