"use strict";

require("source-map-support/register");

var _core = require("@electron-forge/core");

var _fsExtra = _interopRequireDefault(require("fs-extra"));

var _inquirer = _interopRequireDefault(require("inquirer"));

var _commander = _interopRequireDefault(require("commander"));

var _path = _interopRequireDefault(require("path"));

require("./util/terminate");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

_asyncToGenerator(function* () {
  let repo;

  _commander.default.version((yield _fsExtra.default.readJson(_path.default.resolve(__dirname, '../package.json'))).version).arguments('[repository]').option('--prerelease', 'Fetch prerelease versions').action(repository => {
    repo = repository;
  }).parse(process.argv);

  const chooseAsset =
  /*#__PURE__*/
  function () {
    var _ref2 = _asyncToGenerator(function* (assets) {
      const choices = [];
      assets.forEach(asset => {
        choices.push({
          name: asset.name,
          value: asset.id
        });
      });

      const _ref3 = yield _inquirer.default.createPromptModule()({
        choices,
        type: 'list',
        name: 'assetID',
        message: 'Multiple potential assets found, please choose one from the list below:'.cyan
      }),
            assetID = _ref3.assetID;

      return assets.find(asset => asset.id === assetID);
    });

    return function chooseAsset(_x) {
      return _ref2.apply(this, arguments);
    };
  }();

  yield _core.api.install({
    chooseAsset,
    repo,
    interactive: true,
    prerelease: _commander.default.prerelease
  });
})();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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