"use strict";

require("source-map-support/register");

var _core = require("@electron-forge/core");

var _fsExtra = _interopRequireDefault(require("fs-extra"));

var _commander = _interopRequireDefault(require("commander"));

var _path = _interopRequireDefault(require("path"));

require("./util/terminate");

var _workingDir = _interopRequireDefault(require("./util/working-dir"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

_asyncToGenerator(function* () {
  let dir = process.cwd();

  _commander.default.version((yield _fsExtra.default.readJson(_path.default.resolve(__dirname, '../package.json'))).version).arguments('[name]').option('-t, --template [name]', 'Name of the Forge template to use').option('-c, --copy-ci-files', 'Whether to copy the templated CI files (defaults to false)', false).option('-f, --force', 'Whether to overwrite an existing directory (defaults to false)', false).action(name => {
    dir = (0, _workingDir.default)(dir, name, false);
  }).parse(process.argv);

  const initOpts = {
    dir,
    interactive: true,
    copyCIFiles: !!_commander.default.copyCiFiles,
    force: !!_commander.default.force
  };
  if (_commander.default.template) initOpts.template = _commander.default.template;
  yield _core.api.init(initOpts);
})();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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