"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.fakeOra = void 0;

require("source-map-support/register");

require("colors");

var _debug = _interopRequireDefault(require("debug"));

require("log-symbols");

var _ora = _interopRequireDefault(require("ora"));

var _prettyMs = _interopRequireDefault(require("pretty-ms"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/* eslint "no-console": "off" */
const d = (0, _debug.default)('electron-forge:async-ora');
const useFakeOra = Boolean(process.env.DEBUG && process.env.DEBUG.includes('electron-forge'));

if (useFakeOra) {
  console.warn('WARNING: DEBUG environment variable detected.  Progress indicators will be sent over electron-forge:lifecycle'.red);
}

const fakeOra = name => {
  let oraName = name;
  let startTime = null;

  const timing = () => startTime ? `-- after ${`${(0, _prettyMs.default)(Date.now() - startTime)}`.cyan}` : null;

  const fake = {
    start: () => {
      startTime = Date.now();
      d('Process Started:', fake.text);
      return fake;
    },
    fail: () => {
      d(`Process Failed: ${fake.text}`.red, timing);
      return fake;
    },
    succeed: () => {
      d('Process Succeeded:', fake.text, timing());
      return fake;
    },
    stop: () => {
      d('Process Stopped:', fake.text, timing());
      return fake;
    },
    warn: warning => {
      d('Process Warned:', warning, timing());
      return fake;
    },

    get text() {
      return oraName;
    },

    set text(newName) {
      d('Process Renamed:', oraName, ' --> ', newName);
      oraName = newName;
    }

  };
  return fake;
};

exports.fakeOra = fakeOra;

var _default = useFakeOra ? fakeOra : _ora.default;

exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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