"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.OraImpl = void 0;

require("source-map-support/register");

var _colors = _interopRequireDefault(require("colors"));

var _ora = _interopRequireDefault(require("./ora"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/* eslint "no-console": "off" */
class OraImpl {
  // eslint-disable-next-line no-empty-function, no-useless-constructor
  constructor(text = '') {
    this.text = text;
  }

  succeed(_symbol) {
    return this;
  }

  fail(_symbol) {
    return this;
  }

  start() {
    return this;
  }

  stop(_symbol) {
    return this;
  }

  warn(_message) {
    return this;
  }

}

exports.OraImpl = OraImpl;

const asyncOra = (initialOraValue, asyncFn, processExitFn = process.exit) => {
  let fnOra = new OraImpl(initialOraValue);

  if (asyncOra.interactive) {
    fnOra = (0, _ora.default)(initialOraValue).start();
  }

  return new Promise((resolve, reject) => {
    asyncFn(fnOra).then(() => {
      fnOra.succeed();
      resolve();
    }).catch(err => {
      fnOra.fail();

      if (asyncOra.interactive) {
        if (err && err.message && err.stack) {
          console.error('\nAn unhandled error has occurred inside Forge:'.red);
          console.error(_colors.default.red(err.message));
          console.error(_colors.default.red(err.stack));
        } else {
          console.error('\nElectron Forge was terminated:'.red);
          console.error(_colors.default.red(typeof err === 'string' ? err : JSON.stringify(err)));
        }

        processExitFn(1); // If the process is still alive we should continue because either
        // something went really wrong or we are testing this function

        setTimeout(() => resolve(), 500);
      } else {
        reject(err);
      }
    });
  });
};

asyncOra.interactive = true;
var _default = asyncOra;
exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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